@extends('layouts.user')

@push('css')

@endpush

@section('contents')



<div class="container vh-100 d-flex justify-content-center align-items-center bg-light">
    <div class="card shadow-lg p-4 text-center" style="max-width: 450px; width: 100%;">
        <div class="card-body">
            <h3 class="card-title mb-3"><i class="bi bi-geo-alt-fill"></i> Location Required</h3>
            <p class="card-text mb-4">
                To access the dashboard, you must set your current location.
            </p>

            <button id="getLocationBtn" class="btn btn-primary mb-3">
                📍 Set My Location
            </button>

            <form id="locationForm" action="{{ route('location.store') }}" method="POST" class="d-none">
                @csrf
                <input type="hidden" name="latitude" id="latitude">
                <input type="hidden" name="longitude" id="longitude">
                <button type="submit" class="btn btn-success w-100">
                    Save Location
                </button>
            </form>
        </div>
    </div>
</div>

@endsection




@push('js')
<script>
    // document.getElementById('getLocationBtn').addEventListener('click', function() {
    //     if (navigator.geolocation) {
    //         navigator.geolocation.getCurrentPosition(
    //             function(position) {
    //                 document.getElementById('latitude').value = position.coords.latitude;
    //                 document.getElementById('longitude').value = position.coords.longitude;
    //                 document.getElementById('locationForm').classList.remove('hidden');
    //             },
    //             function(error) {
    //                 alert("Location is required to access the dashboard. Please allow location.");
    //             }
    //         );
    //     } else {
    //         alert("Geolocation is not supported by your browser.");
    //     }
    // });


    document.getElementById('getLocationBtn').addEventListener('click', function() {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(
            function(position) {
                document.getElementById('latitude').value = position.coords.latitude;
                document.getElementById('longitude').value = position.coords.longitude;

                // Auto-submit the form
                document.getElementById('locationForm').submit();
            },
            function(error) {
                alert("Location is required to access the dashboard. Please allow location.");
            }
        );
    } else {
        alert("Geolocation is not supported by your browser.");
    }
});

</script>
@endpush
