@extends('layouts.user')

@push('css')
@endpush

@section('contents')
    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-12">
                    <div class="card p-3 py-4 px-sm-4">
                        @includeIf('includes.flash')
                        <form id="request-form" action="{{ route('user.profile.update') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf

                            <div class="row">
                                <div class="col-md-6 mx-auto">
                                    <div class="form-group">
                                        <label class="font-weight-bold">{{ __('Set Image') }} </label>
                                        <div class="wrapper-image-preview">
                                            <div class="box">
                                                <div class="back-preview-image"
                                                    style="background-image: url('{{ auth()->user()->photo ? asset('assets/images/'.auth()->user()->photo) : asset('assets/user/img/user.jpg')}}');">
                                                </div>
                                                <div class="upload-options">
                                                    <label class="img-upload-label" for="img-upload"> <i
                                                            class="fa fa-camera"></i> {{ __('Upload Picture') }}
                                                    </label>
                                                    <input id="img-upload" type="file" class="image-upload"
                                                        name="photo">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label required">{{ __('User Name') }}</label>
                                        <input name="name" class="form-control form--control" autocomplete="off"
                                            placeholder="{{ __('User Name') }}" type="text" value="{{ $user->name }}"
                                            required readonly>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label required">{{ __('Last Name') }}</label>
                                        <input name="last_name" class="form-control form--control" autocomplete="off"
                                            placeholder="{{ __('Last Name') }}" type="text" value="{{ $user->last_name }}"
                                            required readonly>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group" hx-target="this" hx-swap="outerHTML">
                                        <label class="form-label required">{{ __('Email Address') }}</label>
                                        <div class="input-group">
                                            <input name="email" class="form-control form--control" autocomplete="off"
                                                placeholder="{{ __('Email Address') }}" type="email"
                                                value="{{ $user->email }}" required readonly id="email_address">
                                            @if ($user->email_verified_at)
                                                <div class="input-group-text text-success fw-bold"> Verified</div>
                                            @endif
                                        </div>
                                        @if (!$user->email_verified_at)
                                            <div class="mt-1">
                                                <a href="javascript:void(0)"
                                                    hx-post="{{ route('user.profile.send-email-otp') }}"
                                                    hx-include="#email_address"
                                                    @htmx:before-send="$el.setAttribute('disabled', true)"
                                                    class="text-decoration-none">
                                                    <span class="htmx-hide"> Verify Email Address </span>
                                                    <span class="htmx-indicator">
                                                        <span class="spinner-border spinner-border-sm"></span>
                                                        Sending OTP...
                                                    </span>
                                                </a>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group" hx-target="this" hx-swap="outerHTML">
                                        <label class="form-label required">{{ __('Phone Number') }}</label>
                                        <div class="input-group">
                                            <input name="phone" class="form-control form--control" autocomplete="off"
                                                placeholder="{{ __('Phone Number') }}" type="tel"
                                                value="{{ $user->phone }}" required id="phone_number" @readonly($user->phone_verified_at)>
                                            @if ($user->phone_verified_at)
                                                <div class="input-group-text text-success fw-bold"> Verified</div>
                                            @endif
                                        </div>
                                        @if (!$user->phone_verified_at)
                                            <div class="mt-1">
                                                {{-- user.profile.send-phone-otp --}}
                                                <a href="javascript:void(0)"
                                                    hx-post="{{ route('user.profile.send-phone-otp') }}"
                                                    hx-include="#phone_number"
                                                    @htmx:before-send="$el.setAttribute('disabled', true)"
                                                    class="text-decoration-none">
                                                    <span class="htmx-hide"> Verify Phone Number </span>
                                                    <span class="htmx-indicator">
                                                        <span class="spinner-border spinner-border-sm"></span>
                                                        Sending OTP...
                                                    </span>
                                                </a>
                                            </div>
                                        @endif
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label required">{{ __('Address') }}</label>
                                        <input name="address" class="form-control form--control" autocomplete="off"
                                            placeholder="{{ __('Address') }}" type="text"
                                            value="{{ $user->address }}" required>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label required">{{ __('City') }}</label>
                                        <input name="city" class="form-control form--control" autocomplete="off"
                                            placeholder="{{ __('City') }}" type="text"
                                            value="{{ $user->city }}" required>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label required">{{ __('Zip') }}</label>
                                        <input name="zip" class="form-control form--control" autocomplete="off"
                                            placeholder="{{ __('Zip') }}" type="text" value="{{ $user->zip }}"
                                            required>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label ">{{ __('Country') }}</label>
                                        <input name="country" class="form-control form--control" autocomplete="off"
                                            placeholder="{{ __('Country') }}" type="text"
                                            value="{{ $user->country }}" >
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label required">{{ __('Fax') }}</label>
                                        <input name="fax" class="form-control form--control" autocomplete="off"
                                            placeholder="{{ __('Fax') }}" type="text"
                                            value="{{ $user->fax }}" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label ">{{ __('Telegram') }}</label>
                                        <input name="telegram" class="form-control form--control" autocomplete="off"
                                            placeholder="{{ __('Telegram') }}" type="text"
                                            value="{{ $user->telegram }}" >
                                    </div>
                                </div>
                            </div>


                            <div class="form-footer">
                                <button type="submit" class="btn btn-primary submit-btn">{{ __('Submit') }}</button>
                            </div>


                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

<x-htmx-alpine />

@push('js')
    <script type="text/javascript">
        'use strict';

        $('.edit-profile').on('click', function() {
            $('.upload').click();

        });
    </script>
@endpush
