<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: DejaVu Sans, sans-serif; text-align:center; }
        .qr-card {
            border: 2px solid #0d6efd;
            border-radius: 12px;
            padding: 40px 100px;
            margin: 40px auto;
            width: 70%;
            max-width: 800px;
        }
        .qr-card img { width: 300px; margin-bottom: 20px; }
        h1 {
            font-size: clamp(20px, 4vw, 36px);
            margin: 10px 0;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        h2 { font-size: 26px; margin: 8px 0; }
        h3 { font-size: 18px; margin: 6px 0; color: #555; }
    </style>
</head>
<body>
    <div class="qr-card">
        <h3 class="fw-bold mb-3">{{ $gs->title }}</h3>
        <h4 class="fw-semibold mb-4">Scan the QR code to make a payment</h4>
        <img src="{{ $qrImage }}" alt="QR Code">
        <h1>{{ $user->name }} {{ $user->last_name }}</h1>
        <h2>Account No: {{ $user->account_number }}</h2>
        <h3>Account Type: {{ ucfirst($user->account_type) }}</h3>
    </div>
</body>
</html>
