@extends('layouts.front')

@section('content')
    <!-- Hero -->
    <section class="hero-section bg--overlay bg_img" data-img="{{ asset('assets/images/' . $gs->breadcumb_banner) }}">
        <div class="container">
            <div class="hero-content">
                <h2 class="hero-title"></h2>
                <ul class="breadcrumb">
                    <li>
                        <a href="{{ route('front.index') }}">@lang('Home')</a>
                    </li>
                    <li>
                        @lang('Registration')
                    </li>
                </ul>
            </div>
        </div>
    </section>
    <!-- Hero -->

    <!-- Account -->
    <section class="account-section pt-100 pb-100">
        <div class="container">
            <div class="account-wrapper bg--body">
                <div class="section-title mb-3">
                    <h6 class="subtitle text--base">@lang('Sign Up')</h6>
                    <h3 class="title">@lang('Create Account Now')</h3>
                </div>
                <form id="registerform" class="account-form row gy-3 gx-4 align-items-center"
                    action="{{ route('user.register.submit') }}" method="POST">
                    @includeIf('includes.user.form-both')
                    @csrf
                    <div class="col-sm-6 mb-1">
                        <label for="name" class="form-label">@lang('First Name')</label>
                        <input type="text" id="name" name="name" class="form-control form--control">
                    </div>
                    <div class="col-sm-6 mb-1">
                        <label for="lastname" class="form-label">@lang('Last Name')</label>
                        <input type="text" id="lastname" name="last_name" class="form-control form--control">
                    </div>
                    <div class="col-sm-12 mb-1">
                        <label for="email" class="form-label">@lang('Your Email')</label>
                        <input type="text" id="email" name="email" class="form-control form--control">
                    </div>
                    <div class="col-sm-6 mb-2 position-relative">
                        <label for="phone" class="form-label">@lang('Your Phone')</label>
                        <input type="text" id="phone" class="form-control form--control">
                        <small id="phoneError" class="text-danger position-absolute top-100 start-0 ms-3"
                            style="display: none"></small>
                    </div>

                    <div class="col-sm-6 mb-1">
                        <label for="dob" class="form-label">@lang('Dob')</label>
                        <input type="date" id="dob" name="dob" class="form-control form--control">
                    </div>

                    <div class="d-none">
                        <input type="hidden" id="full_phone" name="phone" />
                        <input type="hidden" id="country_code" name="country_code" />
                        <input type="hidden" id="dial_code" name="dial_code" />
                    </div>

                    {{-- <div class="col-sm-6 mb-2">
                        <label for="password" class="form-label">@lang('Your Password')</label>
                        <input type="password" id="password" name="password" class="form-control form--control">
                    </div>
                    <div class="col-sm-6 mb-2">
                        <label for="confirm-password" class="form-label">@lang('Confirm Password')</label>
                        <input type="password" id="confirm-password" name="password_confirmation"
                            class="form-control form--control">
                    </div> --}}

                    <div class="col-sm-6 mb-2 position-relative">
                        <label for="password" class="form-label">@lang('Your Password')</label>
                        <input type="password" id="password" name="password" class="form-control form--control">
                        <span class="toggle-password" onclick="togglePassword('password', this)"
                            style="position:absolute; right:18px; top:72%; transform:translateY(-50%); cursor:pointer;">
                        
                            <i class="fas fa-eye" style="padding: 5px; "></i>
                        </span>
                    </div>

                    <div class="col-sm-6 mb-2 position-relative">
                        <label for="confirm-password" class="form-label">@lang('Confirm Password')</label>
                        <input type="password" id="confirm-password" name="password_confirmation"
                            class="form-control form--control">
                        <span class="toggle-password" onclick="togglePassword('confirm-password', this)"
                            style="position:absolute; right:18px; top:72%; transform:translateY(-50%); cursor:pointer;">
                            <i class="fas fa-eye" style="padding: 5px; "></i>
                        </span>
                    </div>


                    <div class="col-sm-12 d-flex flex-wrap justify-content-between align-items-center">
                        <button type="submit" class="cmn--btn bg--base me-3" id="registerNowButton">
                            @lang('Register Now')
                        </button>
                        <div class="text-end">
                            <a href="{{ route('user.login') }}" class="text--base">@lang('Already have
                                                                                                                                                an account ')?</a>
                        </div>
                    </div>
                    <div class="mt-2">
                        <div class="form-check mt-3 mb-0">
                            <input type="checkbox" id="accept" class="form-check-input" checked>
                            <label class="form-check-label" for="accept">
                                @lang('I accept all the') <a href="/privacy" class="text--base">@lang('privacy & policy')</a>
                            </label>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
    <!-- Account -->
@endsection

@push('css')
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/25.3.1/build/css/intlTelInput.min.css">
    <style>
        .iti,
        .iti input {
            width: 100%;
        }
    </style>
@endpush

@push('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/25.3.1/build/js/intlTelInputWithUtils.min.js">
    </script>
    <script>
        const phoneInputEl = document.querySelector("#phone");
        const phoneInput = window.intlTelInput(phoneInputEl, {
            initialCountry: "us",
            strictMode: true,
            showSelectedDialCode: true,
            separateDialCode: true,
            showFlags: true,
            validationNumberTypes: ["MOBILE"],
            geoIpLookup: (callback) => {
                fetch('https://ipinfo.io/json')
                    .then(res => res.json())
                    .then(data => callback(data.country))
                    .catch(() => callback("us"));
            },
            autoPlaceholder: "off",
        });
        phoneInputEl.placeholder = "0000000";
        $(phoneInputEl).on('countrychange change', function() {
            let countryData = phoneInput.getSelectedCountryData();
            const number = phoneInput.getNumber(intlTelInput.utils.numberFormat.E164);
            $('#full_phone').val(number);
            $('#country_code').val(countryData.iso2);
            $('#dial_code').val(countryData.dialCode);
            if (phoneInput.isValidNumber()) {
                $('#phoneError').html("").hide();
                $('#phone').removeClass('border-danger');
            } else {
                $('#phoneError').html('Invalid phone number').show();
                $('#phone').addClass('border-danger');
            }
        })
        $(document).on('submit', '#registerform', function() {
            $('#registerNowButton').html(`
                <span class="spinner-border spinner-border-sm" aria-hidden="true"></span>
                <span role="status">Loading...</span>
            `).attr('disabled', true);

        });
        $(document).on("ajaxComplete", function() {
            $('#registerNowButton').html('Register Now').attr('disabled', false);
        });
        $(document).on("ajaxSuccess", function() {
            $('#registerform input').each(function() {
                $(this).val('');
            })
        });
    </script>

    <script>
        function togglePassword(id, el) {
            const input = document.getElementById(id);
            if (input.type === "password") {
                input.type = "text";
                el.textContent = "🙈"; 
            } else {
                input.type = "password";
                el.innerHTML  =  '<i class="fas fa-eye" style="padding: 5px; "></i>'; 
            }
        }
    </script>
@endpush
