

<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>

    <div class="container-xl">
        <div class="page-header d-print-none">
            <div class="d-flex flex-wrap justify-content-between">
                <div class="me-3">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title">
                        <?php echo e(__('Deposits')); ?>

                    </h2>
                </div>
                <?php if(!empty($gs->deposit_notice)): ?>
                    <div class="alert alert-warning">
                        <div class="text-danger">
                            <?php echo e(__($gs->deposit_notice)); ?>

                        </div>
                    </div>
                <?php endif; ?>
                <div class="d-print-none">
                    <div class="btn-list">
                        <div class="btn-list">
                            
                            <a href="<?php echo e(route('user.deposit.create')); ?>"
                            class="btn btn-primary d-none d-sm-inline-block <?php echo e(!$isImpersonation ? '' : 'disabled'); ?>"
                            <?php if($isImpersonation): echo 'disabled'; endif; ?>
                            >
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                                <?php echo e(__('Create new Deposit')); ?>

                            </a>

                            
                            <a href="<?php echo e(route('user.deposit.create')); ?>"
                            class="btn btn-primary d-sm-none <?php echo e(!$isImpersonation ? '' : 'disabled'); ?>"
                            <?php if($isImpersonation): echo 'disabled'; endif; ?>
                            >
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-12">
                    <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-5 g-3 mb-3">
                        <div class="col">
                            <div class="card card-sm shadow-sm">
                                <div class="card-body text-center">
                                    <div class="text-h2"><?php echo e($pending ?? 0); ?></div>
                                    <div class="text-muted"><?php echo e(__('Pending')); ?></div>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card card-sm shadow-sm">
                                <div class="card-body text-center">
                                    <div class="text-h2"><?php echo e($complete ?? 0); ?></div>
                                    <div class="text-muted"><?php echo e(__('Complete')); ?></div>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card card-sm shadow-sm">
                                <div class="card-body text-center">
                                    <div class="text-h2"><?php echo e($cancelled ?? 0); ?></div>
                                    <div class="text-muted"><?php echo e(__('Cancelled')); ?></div>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card card-sm shadow-sm">
                                <div class="card-body text-center">
                                    <div class="text-h2"><?php echo e($processing ?? 0); ?></div>
                                    <div class="text-muted"><?php echo e(__('Processing')); ?></div>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card card-sm shadow-sm">
                                <div class="card-body text-center">
                                    <div class="text-h2"><?php echo e($onhold ?? 0); ?></div>
                                    <div class="text-muted"><?php echo e(__('On Hold')); ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card">
                        <?php if(count($deposits) == 0): ?>
                            <h3 class="text-center py-5"><?php echo e(__('No Deposit Data Found')); ?></h3>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-vcenter table-mobile-md card-table">
                                    <thead>
                                    <tr>
                                        <th><?php echo e(__('Deposit Date')); ?></th>
                                        <th><?php echo e(__('Method')); ?></th>
                                        <th><?php echo e(__('Account')); ?></th>
                                        <th><?php echo e(__('Amount')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td data-label="<?php echo e(__('Deposit Date')); ?>">
                                                <div>
                                                    <?php echo e(date('d-M-Y',strtotime($deposit->created_at))); ?>

                                                </div>
                                            </td>
                                            <td data-label="<?php echo e(__('Method')); ?>">
                                                <div>
                                                    <?php if($deposit->method=='Manual' && $deposit->gateway?->title): ?>
                                                        <?php echo e($deposit->gateway?->title); ?> (<?php echo e($deposit->method); ?>)
                                                    <?php else: ?>
                                                        <?php echo e(ucwords($deposit->method)); ?>

                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                            <td data-label="<?php echo e(__('Account')); ?>">
                                                <div>
                                                    <?php echo e(auth()->user()->email); ?>

                                                </div>
                                            </td>

                                            <td data-label="<?php echo e(__('Amount')); ?>">
                                                <div>
                                                    <?php echo e(showprice($deposit->amount,$currency)); ?>

                                                </div>
                                            </td>

                                            <td data-label="<?php echo e(__('Status')); ?>">
                                                <div>
                                                    <?php echo e(ucfirst($deposit->status)); ?>

                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php echo e($deposits->links()); ?>

                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>

<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/public_html/bank/core/resources/views/user/deposit/index.blade.php ENDPATH**/ ?>