

<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>
    <div class="container-xl">
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <h2 class="page-title">
                        <?php echo e(__('Two factor authentication')); ?>

                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <?php if(Auth::user()->twofa): ?>
                        <div class="card border-0 shadow-sm">
                            <div class="card-header">
                                <h5 class="card-title text-dark text-center"><?php echo app('translator')->get('Two Factor Authenticator'); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group mx-auto text-center">
                                    <a href="javascript:void(0)" class="btn w-100 btn-md btn--danger"
                                       data-bs-toggle="modal" data-bs-target="#disableModal">
                                        <?php echo app('translator')->get('Disable Two Factor Authenticator'); ?></a>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="card border-0 shadow-sm">
                            <div class="card-header">
                                <h5 class="card-title text-dark text-center"><?php echo app('translator')->get('Two Factor Authenticator'); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group mx-auto text-center">
                                    <div class="input-group input--group">
                                        <input type="text" name="key" value="<?php echo e($secret); ?>" class="form-control"
                                               id="referralURL" readonly>
                                        <button class="btn input-group-text btn--secondary btn-sm copytext"
                                                id="copyBoard" onclick="myFunction()"><i class="fa fa-copy"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="form-group mx-auto text-center mt-3">
                                    <img class="mx-auto" src="<?php echo e($qrCodeUrl); ?>">
                                </div>
                                <div class="form-group mx-auto text-center">
                                    <a href="javascript:void(0)"
                                       class="btn btn--base btn-md mt-3 mb-1 <?php echo e(!$isImpersonation?'':'disabled'); ?>"
                                       <?php if($isImpersonation): echo 'disabled'; endif; ?>
                                       data-bs-toggle="modal"
                                       data-bs-target="#enableModal"><?php echo app('translator')->get('Enable Two Factor Authenticator'); ?></a>
                                </div>

                                <div class="form-group mx-auto text-center">
                                    <a class="btn btn--base btn-md mt-3"
                                       href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en"
                                       target="_blank"><?php echo app('translator')->get('DOWNLOAD APP'); ?></a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="card border-0 shadow-sm d-none">
                        <div class="card-header">
                            <h5 class="card-title text-dark text-center"><?php echo app('translator')->get('Two Factor Authentication via Email'); ?></h5>
                        </div>
                        <div class="card-body">
                            <form
                                x-data="{
                                    enabled: <?php echo e($user->email_2fa == 1 ? 'true' : 'false'); ?>,
                                }"
                                id="enable_email_2fa_form"
                                x-ref="enable_email_2fa_form"
                            >
                                <div class="form-group mb-3">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-label text-muted">Enable/Disable 2FA via Email</div>
                                    <label
                                        class="form-check form-switch form-switch-lg d-inline-flex align-items-center gap-2">
                                        <input
                                            type="checkbox"
                                            class="form-check-input"
                                            <?php if($user->email_2fa == 1): echo 'checked'; endif; ?>
                                            hx-trigger="change"
                                            hx-post="?action=<?php echo e($user->email_2fa == 1 ? 'disable-email-2fa' : 'enable-email-2fa'); ?>"
                                            hx-target="#enable_email_2fa_form"
                                            hx-swap="outerHTML"
                                            @htmx:response-error="toastr.error('Failed to change status')"
                                        />
                                        <span class="form-check-label" x-text="enabled ? 'Enabled' : 'Disabled'">
                                            <?php echo e($user->email_2fa == 1 ? 'Enabled' : 'Disabled'); ?>

                                        </span>
                                    </label>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!--Enable Modal -->
            <div id="enableModal" class="modal modal-blur fade" role="dialog" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog ">
                    <!-- Modal content-->
                    <div class="modal-content ">
                        <div class="modal-header">
                            <h4 class="modal-title"><?php echo app('translator')->get('Verify Your Otp'); ?></h4>
                        </div>
                        <form action="<?php echo e(route('user.createTwoFactor')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="modal-body ">
                                <div class="form-group">
                                    <input type="hidden" name="key" value="<?php echo e($secret); ?>">
                                    <input type="text" class="form-control" name="code"
                                           placeholder="<?php echo app('translator')->get('Enter Google Authenticator Code'); ?>">
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger"
                                        data-bs-dismiss="modal"><?php echo app('translator')->get('close'); ?></button>
                                <button type="submit" class="btn btn-success"><?php echo app('translator')->get('verify'); ?></button>
                            </div>
                        </form>
                    </div>

                </div>
            </div>

            <!--Disable Modal -->
            <div id="disableModal" class="modal modal-blur fade" role="dialog" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog">
                    <!-- Modal content-->
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title"><?php echo app('translator')->get('Verify Your Otp Disable'); ?></h4>
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                        </div>
                        <form action="<?php echo e(route('user.disableTwoFactor')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="modal-body">
                                <div class="form-group">
                                    <input type="text" class="form-control" name="code"
                                           placeholder="<?php echo app('translator')->get('Enter Google Authenticator Code'); ?>">
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger"
                                        data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                                <button type="submit" class="btn btn-success"><?php echo app('translator')->get('Verify'); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php if (isset($component)) { $__componentOriginalaeff4b44922fb48bfa886b58bb8c2797 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaeff4b44922fb48bfa886b58bb8c2797 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.htmx-alpine','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('htmx-alpine'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaeff4b44922fb48bfa886b58bb8c2797)): ?>
<?php $attributes = $__attributesOriginalaeff4b44922fb48bfa886b58bb8c2797; ?>
<?php unset($__attributesOriginalaeff4b44922fb48bfa886b58bb8c2797); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaeff4b44922fb48bfa886b58bb8c2797)): ?>
<?php $component = $__componentOriginalaeff4b44922fb48bfa886b58bb8c2797; ?>
<?php unset($__componentOriginalaeff4b44922fb48bfa886b58bb8c2797); ?>
<?php endif; ?>

<?php $__env->startPush('js'); ?>

    <script>
        "use strict";

        function myFunction() {
            var copyText = document.getElementById("referralURL");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            document.execCommand("copy");
            alert('copied');
        }
    </script>

    <script src="<?php echo e(asset('assets/user/js/sweetalert2@9.js')); ?>"></script>

    <?php if($errors->any()): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <script>
                const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    onOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                })
                Toast.fire({
                    icon: 'error',
                    title: '<?php echo e($error); ?>'
                })
            </script>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>


    <?php if(Session::has('success')): ?>
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                onOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            })
            Toast.fire({
                icon: 'success',
                title: '<?php echo e(Session::get('success')); ?>'
            })
        </script>
    <?php endif; ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/public_html/bank/core/resources/views/user/twofactor/index.blade.php ENDPATH**/ ?>