

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e($data->name); ?></h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                <li class="breadcrumb-item"><a href="javascript:;"><?php echo e(__('User')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.user.index')); ?>"><?php echo e(__('Users')); ?></a></li>
            </ol>
        </div>
    </div>


    <div class="row mt-3">
        <div class="col-lg-12">
            <?php
                $currency = defaultCurr();
            ?>
            <?php echo $__env->make('includes.admin.form-success', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <div class="card mb-4">
                <div class="row">
                    <div class="col-md-2">
                        <div class="user-image">
                            <?php if($data->is_provider == 1): ?>
                                <img src="<?php echo e($data->photo ? asset($data->photo) : asset('assets/images/noimage.png')); ?>"
                                    alt="No Image">
                            <?php else: ?>
                                <img class=""
                                    src="<?php echo e($data->photo ? asset('assets/images/' . $data->photo) : asset('assets/images/noimage.png')); ?>"
                                    alt="No Image">
                            <?php endif; ?>
                            <a class="mybtn1 btn btn-primary" data-email="<?php echo e($data->email); ?>" data-toggle="modal"
                                data-target="#vendorform" href=""><?php echo e(__('Send Message')); ?></a>

                            <form class="mt-3" action="<?php echo e(route('admin.login-to-user')); ?>" method="POST" target="_blank"
                                onsubmit="return confirm('Are you sure you want to login to this user?')">
                                <?php echo e(csrf_field()); ?>

                                <input name="user_id" value="<?php echo e($data->id); ?>" type="hidden" />

                                <button class="mybtn1 btn btn-primary" type="submit"><?php echo e(__('Login to User')); ?></button>
                            </form>

                            <?php if($data->is_suspended): ?>
                                <a href="<?php echo e(route('admin-user-ban', [$data->id, '0'])); ?>" class="mybtn1 btn btn-warning"
                                    onclick="return confirm('Do you want to unsuspend the user?')"><?php echo e(__('User Suspended')); ?></a>
                                <div>
                                    <?php echo e($data->suspend_reason); ?>

                                </div>
                            <?php endif; ?>

                        </div>
                    </div>
                    <div class="col-md-5 mt-5">
                        <div class="table-responsive show-table">
                            <table class="table">
                                <tr>
                                    <th><?php echo e(__('ID#')); ?></th>
                                    <td><?php echo e($data->id); ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo e(__('Username')); ?></th>
                                    <td><?php echo e($data->name); ?> <?php echo e($data->last_name); ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo e(__('Email')); ?></th>
                                    <td><?php echo e($data->email); ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo e(__('Address')); ?></th>
                                    <td><?php echo e($data->address); ?></td>
                                </tr>

                                <tr>
                                    <th><?php echo e(__('City')); ?></th>
                                    <td><?php echo e($data->city); ?></td>
                                </tr>

                                <tr>
                                    <th><?php echo e(__('Zip Code')); ?></th>
                                    <td><?php echo e($data->zip); ?></td>
                                </tr>

                                <tr>
                                    <th><?php echo e(__('Joined')); ?></th>
                                    <td><?php echo e($data->created_at->diffForHumans()); ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo e(__('Date of Birth')); ?></th>
                                    <td><?php echo e($data->dob); ?></td>
                                </tr>

                            </table>
                        </div>
                    </div>
                    <div class="col-md-4 mx-auto mt-5">
                        <div class="card-title text-center">
                            <h5 class="mb-0 font-weight-medium">
                                <?php echo app('translator')->get('Available Balance'); ?>:
                            </h5>
                            <h4 class="mb-0 font-weight-bold">
                                <?php echo e(number_format(round($data->balance, 4), 2)); ?> <?php echo e($currency->name); ?>

                            </h4>
                        </div>
                        
                        <?php
                            $authUser = Auth::guard('admin')->user();
                        ?>
                        <?php if($authUser->IsSuper()): ?>
                            <form action="<?php echo e(route('admin.user.balance.add.deduct')); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label for="inp-address"><?php echo e(__('Amount')); ?></label>
                                    <input type="number" class="form-control" id="inp-address" name="amount"
                                        placeholder="<?php echo e(__('Enter Amount')); ?>" value="" min="0" step="0.01"
                                        required>
                                </div>

                                <input type="hidden" name="user_id" value="<?php echo e($data->id); ?>">

                                <div class="form-group">
                                    <label for="exampleFormControlSelect1"><?php echo app('translator')->get('Select Method'); ?></label>
                                    <select class="form-control" name="type" id="exampleFormControlSelect1" required>
                                        <option value="add"><?php echo app('translator')->get('add amount'); ?></option>
                                        <option value="subtract"><?php echo app('translator')->get('subtract amount'); ?></option>
                                    </select>
                                </div>
                                <button type="submit" id="submit-btn"
                                    class="btn btn-primary w-100"><?php echo e(__('Submit')); ?></button>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
        </div>

    </div>

    <div class="row mb-3">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('LOAN')); ?></div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(count($loans)); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-cash-register fa-2x text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('DPS')); ?></div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(count($dps)); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-warehouse fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('FDR')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800"><?php echo e(count($dps)); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-shield fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('WITHDRAW')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800"><?php echo e(count($withdraws)); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-file-signature fa-2x text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                'h-100 p-3 text-center',
                'success-box' => $data->email_verified_at,
                'failed-box' => !$data->email_verified_at,
            ]); ?>">
                <a class="">
                    <div class=" ">

                        <p>Email Verified - <?php echo e($data->email_verified_at ? 'Yes' : 'No'); ?></p>

                    </div>
                </a>
            </div>
        </div>


        <div class="col-xl-3 col-md-6 mb-4">
            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                'h-100 p-3 text-center',
                'success-box' => $data->phone_verified_at,
                'failed-box' => !$data->phone_verified_at,
            ]); ?>">
                <a class="">
                    <div class=" ">

                        <p>Phone Verified - <?php echo e($data->phone_verified_at ? 'Yes' : 'No'); ?></p>

                    </div>
                </a>
            </div>
        </div>


        <div class="col-xl-3 col-md-6 mb-4">
            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                'h-100 p-3 text-center',
                'success-box' => $data->kyc_status == 1,
                'failed-box' => !$data->kyc_status == 1 || $data->kyc_status == 2,
            ]); ?>">
                <a class="">
                    <div class=" ">

                        <p>Kyc Status -   <?php echo e($data->kyc_status == 1 ? 'Yes' : ($data->kyc_status == 2 ? 'Reject' : 'No')); ?></p>

                    </div>
                </a>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                'h-100 p-3 text-center',
                'success-box' => $data->email_2fa,
                'failed-box' => !$data->email_2fa,
            ]); ?>">
                <a href="<?php echo e(route('admin-user-email2fa', [$data->id, $data->email_2fa ? 'disable' : 'enable'])); ?>"
                    class="">
                    <div class=" ">

                        <p>Email 2Fa <?php echo e($data->email_2fa ? 'Disable' : 'Enable'); ?></p>

                    </div>
                </a>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                'h-100 p-3 text-center',
                'success-box' => $data->twofa,
                'failed-box' => !$data->twofa,
            ]); ?>">
                <a href="<?php echo e(route('admin-user-app2fa', [$data->id, $data->twofa ? 'disable' : 'enable'])); ?>"
                    class="">
                    <div class=" ">
                        <p> 2Fa <?php echo e($data->twofa ? 'Disable' : 'Enable'); ?></p>
                    </div>
                </a>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                'h-100 p-3 text-center',
                'success-box' => $data->is_banned,
                'failed-box' => !$data->is_banned,
            ]); ?>">
                <a href="<?php echo e(route('admin-user-ban', [$data->id, $data->is_banned ? 0 : 1])); ?>" class="">
                    <div class=" ">
                        <p> <?php echo e($data->is_banned ? 'Block' : '  Unblock'); ?></p>
                    </div>
                </a>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                'h-100 p-3 text-center',
                'success-box' => $data->is_suspended,
                'failed-box' => !$data->is_suspended,
            ]); ?>">
                <a href="javascript:void(0);" data-user-id="<?php echo e($data->id); ?>" data-toggle="modal"
                    data-target="#unsuspendModal" class=" suspend-user">
                    <div class=" ">
                        <?php echo e($data->is_suspended ? 'Suspended' : 'Unsuspended'); ?>

                    </div>
                </a>
            </div>
        </div>
    </div>
    <!--Row-->

    

    <div class="modal fade confirm-modal" id="statusModal" tabindex="-1" role="dialog"
        aria-labelledby="statusModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Update Status')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center"><?php echo e(__('You are about to change the status.')); ?></p>
                    <p class="text-center"><?php echo e(__('Do you want to proceed?')); ?></p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Cancel')); ?></a>
                    <a href="javascript:;" class="btn btn-success btn-ok"><?php echo e(__('Update')); ?></a>
                </div>
            </div>
        </div>
    </div>

    


    
    <div class="sub-categori">
        <div class="modal fade confirm-modal" id="vendorform" tabindex="-1" role="dialog"
            aria-labelledby="vendorformLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="vendorformLabel"><?php echo e(__('Send Message')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="container-fluid p-0">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="contact-form">
                                        <form id="emailreply1">
                                            <?php echo e(csrf_field()); ?>


                                            <div class="form-group">
                                                <input type="email" class="form-control" id="eml1" name="to"
                                                    placeholder="<?php echo e(__('Email')); ?>" value="<?php echo e($data->email); ?>"
                                                    required="">
                                            </div>
                                            <div class="form-group">
                                                <input type="text" class="form-control" id="subj1" name="subject"
                                                    placeholder="<?php echo e(__('Subject')); ?>" value="" required="">
                                            </div>
                                            <div class="form-group">
                                                <textarea class="form-control" name="message" id="msg1" cols="20" rows="6"
                                                    placeholder="<?php echo e(__('Your Message')); ?> " required=""></textarea>
                                            </div>


                                            <button class="submit-btn btn btn-primary text-center" id="emlsub1"
                                                type="submit"><?php echo e(__('Send Message')); ?></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    

    

    <div class="modal fade confirm-modal" id="deleteModal" tabindex="-1" role="dialog"
        aria-labelledby="deleteModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Confirm Delete')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center"><?php echo e(__('You are about to delete this Blog.')); ?></p>
                    <p class="text-center"><?php echo e(__('Do you want to proceed?')); ?></p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Cancel')); ?></a>
                    <a href="javascript:;" class="btn btn-danger btn-ok"><?php echo e(__('Delete')); ?></a>
                </div>
            </div>
        </div>
    </div>

    

    
    <div class="modal fade confirm-modal" id="unsuspendModal" tabindex="-1" role="dialog"
        aria-labelledby="unsuspendModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form action="<?php echo e($data->is_suspended ? route('admin-user-unsuspend') : route('admin-user-suspend')); ?> "
                    method="POST">
                    <?php echo e(csrf_field()); ?>

                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('Update Status')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <?php if($data->is_suspended): ?>
                        <div class="modal-body">
                            <p class="text-center"><?php echo e(__('You are going to unsuspend the user.')); ?></p>
                            <input type="hidden" name="user_id" value="<?php echo e($data->id); ?>" id="unsuspend_user_id">
                        </div>
                    <?php else: ?>
                        <div class="modal-body">
                            <p class="text-center">You are about to suspend the user.</p>
                            <label for="" class="form-control-label">Suspend Reason</label>
                            <textarea class="form-control" name="suspend_reason" placeholder="Write Suspend Reason" required=""></textarea>
                            <input type="hidden" name="user_id" id="suspend_user_id" value="<?php echo e($data->id); ?>">
                        </div>
                    <?php endif; ?>
                    <div class="modal-footer">
                        <a href="javascript:void(0)" class="btn btn-secondary"
                            data-dismiss="modal"><?php echo e(__('Cancel')); ?></a>
                        <button type="submit" class="btn btn-success">
                            <?php if($data->is_suspended): ?>
                                <?php echo e(__('Unsuspend')); ?>

                            <?php else: ?>
                                <?php echo e(__('Suspend')); ?>

                            <?php endif; ?>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    






    <style>
        .success-box,
        .success-box a {
            background: #118864;
            color: aliceblue;
        }

        .failed-box,
        .failed-box a {
            background: #dd4c64;
            color: white;
        }
    </style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/public_html/bank/core/resources/views/admin/user/show.blade.php ENDPATH**/ ?>