

<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>
    <div class="container-xl">
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <h2 class="page-title">
                        <?php echo e(__('FDR Apply Form')); ?>

                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-md-12">
                    <div class="card p-4">
                        <table class="table table-transparent table-responsive">

                            <tbody>
                            <tr>
                                <td>
                                    <p class="strong mb-1"><?php echo e(__('Plan Title')); ?></p>
                                </td>
                                <td class="text-end"><?php echo e($data->title); ?></td>
                            </tr>

                            <tr>
                                <td>
                                    <p class="strong mb-1"><?php echo e(__('FDR Amount')); ?></p>
                                </td>
                                <td class="text-end"><?php echo e($currency->sign); ?> <?php echo e($fdrAmount); ?></td>
                            </tr>

                            <tr>
                                <td>
                                    <p class="strong mb-1"><?php echo e(__('Locked In Period')); ?></p>
                                </td>
                                <td class="text-end"> <?php echo e($data->matured_days); ?> <?php echo e(__('Days')); ?></td>
                            </tr>

                            <?php if($data->interval_type == 'partial'): ?>
                                <tr>
                                    <td>
                                        <p class="strong mb-1"><?php echo e(__('Get Profit Every')); ?></p>
                                    </td>
                                    <td class="text-end"> <?php echo e($data->interest_interval); ?> <?php echo e(__('Days')); ?></td>
                                </tr>
                            <?php else: ?>
                                <tr>
                                    <td>
                                        <p class="strong mb-1"><?php echo e(__('Get Profit')); ?></p>
                                    </td>
                                    <td class="text-end"> <?php echo e(('After Locked Period')); ?></td>
                                </tr>
                            <?php endif; ?>

                            <tr>
                                <td>
                                    <p class="strong mb-1"><?php echo e(__('Interest Rate In Total Deposit')); ?></p>
                                </td>
                                <td class="text-end"> <?php echo e($data->interest_rate); ?> (%)</td>
                            </tr>

                            <tr>
                                <td>
                                    <p class="strong mb-1 text-success"><?php echo e(__('Amount To Get')); ?></p>
                                </td>
                                <td class="text-end text-success"><?php echo e(showprice((($fdrAmount * $data->interest_rate)/100),$currency)); ?></td>
                            </tr>

                            </tbody>
                        </table>

                        <form action="<?php echo e(route('user.fdr.request')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="plan_id" value="<?php echo e($data->id); ?>">
                            <input type="hidden" name="fdr_amount" value="<?php echo e($fdrAmount); ?>">
                            <input type="hidden" name="profit_amount"
                                   value="<?php echo e(($fdrAmount * $data->interest_rate)/100); ?>">

                            <button type="submit" id="submit-btn" <?php if($isImpersonation): echo 'disabled'; endif; ?>
                                    class="btn btn-primary w-100 <?php echo e(!$isImpersonation?'':'disabled'); ?>"><?php echo e(__('Submit')); ?></button>
                        </form>

                    </div>
                </div>

            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>

<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/public_html/bank/core/resources/views/user/fdr/apply.blade.php ENDPATH**/ ?>