<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('Balance Report')); ?></h5>
            <ol class="breadcrumb m-0 py-0">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                <li class="breadcrumb-item"><a href="javascript:;"><?php echo e(__('Balance Report')); ?></a></li>
            </ol>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-light">
                    <h5 class="mb-0"><?php echo e(__('Customer Financial Summary')); ?></h5>
                </div>
                <div class="card-body p-0">
                    <table class="table table-bordered mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th><?php echo e(__('Description')); ?></th>
                                <th class="text-right"><?php echo e(__('Amount')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $totals = [
                                    'Total Customer Balance'                    => ['value' => $usersTotalBalance, 'sign' => '-'],
                                    'Total Customer Dps'                        => ['value' => $dpsamount, 'sign' => '-'],
                                    'Total Customer Fdr'                        => ['value' => $fdramount, 'sign' => '-'],
                                    'Total Customer Loan'                       => ['value' => $loanamount, 'sign' => '+'],
                                    'Total Withdraw Pending'                    => ['value' => $withdrawPendingAmount, 'sign' => '-'],
                                    'Total Other Bank Pending Amount'           => ['value' => $otherBankPending, 'sign' => '-'],
                                    'Total Wire Transfer Pending Amount'        => ['value' => $wireTransferPending, 'sign' => '-'],
                                    'Total Bonus Point Amount'                  => ['value' => $bonusPointAmount, 'sign' => '-'],
                                ];

                                $subtotal = 0;
                                foreach($totals as $t) {
                                    $subtotal += ($t['sign'] === '+') ? $t['value'] : -$t['value'];
                                }
                            ?>

                            <?php $__currentLoopData = $totals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(__($label)); ?></td>
                                    <td class="text-right">
                                        <?php if($t['sign'] === '-'): ?>
                                            - <?php echo e(amount_format(abs($t['value']))); ?> <?php echo e($currency->name); ?>

                                        <?php else: ?>
                                            <?php echo e(amount_format($t['value'])); ?> <?php echo e($currency->name); ?>

                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot class="font-weight-bold">
                            <tr>
                                <td class="text-uppercase"><?php echo e(__('Total')); ?></td>
                                <td class="text-right">
                                    <?php if($subtotal < 0): ?>
                                        - <?php echo e(amount_format(abs($subtotal))); ?> <?php echo e($currency->name); ?>

                                    <?php else: ?>
                                        <?php echo e(amount_format($subtotal)); ?> <?php echo e($currency->name); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/payovxnb/public_html/bank/core/resources/views/admin/reports/balance-report.blade.php ENDPATH**/ ?>