<?php

namespace App\Http\Controllers\User;

use PDF;
use Auth;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Deposit;
use App\Models\UserDps;
use App\Models\UserFdr;
use App\Models\BankPlan;
use App\Models\UserLoan;
use Tzsk\Otp\Facades\Otp;
use Endroid\QrCode\QrCode;
use App\Models\Transaction;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Classes\GeniusMailer;
use App\Models\Generalsetting;
use App\Models\BalanceTransfer;
use Endroid\QrCode\Color\Color;
use App\Exports\StatementExport;
use App\Models\UserNotification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Classes\GoogleAuthenticator;
use App\Http\Controllers\Controller;
use App\Models\CustomerNotification;
use Endroid\QrCode\Writer\PngWriter;

use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use Maatwebsite\Excel\Facades\Excel;
use Endroid\QrCode\Encoding\Encoding;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;
use Yajra\DataTables\Exceptions\Exception;
use Illuminate\Database\Eloquent\Casts\Json;
use Illuminate\Support\Facades\Auth as FacadesAuth;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $data['user'] = Auth::user();
        $data['transactions'] = Transaction::with('receiver_user', 'user', 'sender_user')
            // ->where('type', '!=', 'Bank Plan')
            ->where('user_id', auth()->id())
            ->orderBy('id', 'desc')
            ->limit(10)
            ->get();
        $data['loanamount'] = UserLoan::where('user_id', auth()->id())->where('status', 1)->sum('loan_amount');
        $data['dpsamount'] = UserDps::where('user_id', auth()->id())->sum('paid_amount');
        $data['fdramount'] = UserFdr::where('user_id', auth()->id())->sum('amount');
        // dd($data['user']);



        return view('user.dashboard', $data);
    }

    /**
     * @throws Exception
     */

    public function transaction()
    {
        $currency = globalCurrency();

        if (request()->ajax()) {
            $transactions = Transaction::with('receiver_user', 'user', 'sender_user')
                ->where(function ($query) {
                    $query->where('user_id', auth()->id());
                    // ->orWhere('receiver_id', auth()->id());
                });


            if (request()->filled('from_date')) {
                $transactions->whereDate('created_at', '>=', request('from_date'));
            }

            if (request()->filled('to_date')) {
                $transactions->whereDate('created_at', '<=', request('to_date'));
            }

            return DataTables::eloquent($transactions)
                ->addIndexColumn()
                ->editColumn('created_at', function ($row) {
                    return date('d M Y H:i', strtotime($row->created_at));
                })
                 ->filterColumn('type', function ($query, $keyword) {
                    $query->where('type', 'like', "%{$keyword}%");
                })
                ->editColumn('type', function ($row) {
                    return strtoupper($row->type);
                })
                ->addColumn('sender_account', function ($row) {
                    return $row->sender_user ? $row->sender_user->account_number : '-';
                })
                ->addColumn('receiver_account', function ($row) {
                    return $row->receiver_user ? $row->receiver_user->account_number : '-';
                })

                ->filterColumn('sender_account', function ($query, $keyword) {
                    $query->whereHas('sender_user', function ($q) use ($keyword) {
                        $q->where('account_number', 'like', "%{$keyword}%");
                    });
                })
                ->filterColumn('receiver_account', function ($query, $keyword) {
                    $query->whereHas('receiver_user', function ($q) use ($keyword) {
                        $q->where('account_number', 'like', "%{$keyword}%");
                    });
                })

                ->addColumn('debit', function ($row) use ($currency) {
                    if ($row->profit == 'minus') {
                        return '<p class="m-0 text-danger">' . showprice($row->amount, $currency) . '</p>';
                    }
                    return '0.00';
                })


                ->addColumn('credit', function ($row) use ($currency) {
                    if ($row->profit == 'plus') {
                        return '<p class="m-0 text-success">' . showprice($row->amount, $currency) . '</p>';
                    }
                    return '0.00';
                })

                ->editColumn('charge', function ($row) use ($currency) {
                    return  auth()->user()->id == $row->user_id ?  showprice($row->charge, $currency)   : "0.00";
                })
                // ->addColumn('balance', '-')
                ->editColumn('available_balance', function ($row) {
                    return  auth()->user()->id == $row->user_id ?   strtoupper($row->user_available_balance)  : strtoupper($row->receiver_available_balance);
                })
                ->addColumn('dummy', '')
                ->rawColumns(['credit', 'debit'])
                ->toJson();
        }

        return view('user.transactions', [
            'user' => Auth::user()
        ]);
    }

    public function bonuswithdraw()
    {
        return view('user.bonuswithdraw', [
            'user' => Auth::user()
        ]);
    }

    public function bonuswithdrawStore()
    {

        $user  = Auth::user();
        $gs = Generalsetting::first();
        //  return ($user->bonus_point);
        if ( $user->bonus_point >= $gs->min_withdraw_point && $user->bonus_point <= $gs->max_withdraw_point) {
            $user->increment('balance',  $user->bonus_point);
            $txnid = Str::random(4) . time();
            $trans = new Transaction();
            $trans->email = $user->email;
            $trans->amount = $user->bonus_point;
            $trans->type = "Bonus Money";
            $trans->profit = "plus";
            $trans->txnid = $txnid;
            $trans->user_id = $user->id;
            // $trans->receiver_id = $receiver->id;
            $trans->charge = 0;
            $trans->user_available_balance = $user->balance;
            // $trans->receiver_available_balance = $receiver->balance;
            $trans->save();

            $user->update(['bonus_point' => 0]);

            if ($gs->is_smtp == 1) {
                $emailData = [
                    'to' => $user->email,
                    'type' => "bonus withdraw",
                    'cname' => $user->name . '' . $user->last_name,
                    'oamount' => $trans->amount,
                    'aname' => "",
                    'aemail' => "",
                    'wtitle' => "",
                ];

                $mailer = new GeniusMailer();
                $mailer->sendAutoMail($emailData);
            } else {
                $to = $user->email;
                $subject = " Bonus Withdraw Confirmed.";
                $msg = "Hello " . $user->name . '' . $user->last_name . "!\nBonus Withdraw Confirmed.\nThank you.";
                $headers = "From: " . $gs->from_name . "<" . $gs->from_email . ">";
                mail($to, $subject, $msg, $headers);
            }

            return redirect()->route('user.dashboard')->with('success', 'Money Add Successfully');
        } else {
            return redirect()->back()->with('unsuccess', "You have not enough bonus points to withdraw. requre min $gs->min_withdraw_point and max $gs->max_withdraw_point point");
        }
    }

    public function downloadStatement()
    {
        $user = Auth::user();

        request()->validate([
            'from' => 'nullable|date',
            'to' => 'nullable|date',
        ]);

        $transactions = [];

        if (request('from') && request('to')) {
            $transactions = Transaction::query()
                ->whereBetween(DB::raw('DATE(created_at)'), [request('from'), request('to')])
                ->whereUserId(auth()->id())
                ->orderBy('id', 'desc')
                ->paginate(20);
        }

        return view('user.download-statement', compact('user', 'transactions'));
    }

    public function generatePDF()
    {
        $gs = Generalsetting::first();
        $ps = DB::table('pagesettings')->first();
        $user = auth()->user();
        $data = [
            'title' => $gs->title,
            'email' => $ps->email,
            'phone' => $ps->phone,
            'user_name' => $user->name . ' ' . $user->last_name,
            'user_account_number' => $user->account_number,
            'user_address' => implode(', ', array_filter([$user->address,$user->city,$user->zip,$user->country])),
            'user_phone' => $user->phone,
            'account_number' => $user->account_number,
            'account_type' => $user->account_type,
            'currency_name' => globalCurrency()->name,
            'company_logo' => asset('assets/images/'.$gs->logo),
            'date' => date('Y-m-d'),
            'from' => request('from'),
            'to' => request('to'),
        ];

        request()->validate([
            'from' => 'required|date',
            'to' => 'required|date',
        ]);

        $data['transactions'] = Transaction::query()
            ->whereBetween(DB::raw('DATE(created_at)'), [request('from'), request('to')])
            ->whereUserId(auth()->id())
            ->orderBy('id', 'desc')
            ->get();

            return view('frontend.statement-pdf', $data);

        $pdf = PDF::loadView('frontend.statement-pdf', $data)
          ->setPaper('A4');

        return $pdf->stream(uniqid('transaction-') . '.pdf');

        //return $pdf->download(uniqid('transaction-').'.pdf');
    }

    public function exportBanksolvency()
    {
        $gs = Generalsetting::first();
        $ps = DB::table('pagesettings')->first();
        $user = auth()->user();
        $data = [
            'title' => $gs->title,
            'email' => $ps->email,
            'phone' => $ps->phone,
            'user_name' => $user->name . ' ' . $user->last_name,
            'user_account_number' => $user->account_number,
            'user_address' => implode(', ', array_filter([$user->address,$user->city,$user->zip,$user->country])),
            'user_phone' => $user->phone,
            'account_number' => $user->account_number,
            'account_type' => $user->account_type,
            'account_opening_date' => $user->created_at->format('d-M-Y'),
            'balance' => $user->balance,
            'dob' => $user->dob,
            'currency_name' => globalCurrency()->name,
            'company_logo' => asset('assets/images/'.$gs->logo),
        ];

        // return view('frontend.bank-solvency-pdf', $data);

        $pdf = PDF::loadView('frontend.bank-solvency-pdf', $data)
          ->setPaper('A4');

        return $pdf->stream(uniqid('transaction-') . '.pdf');
    }

    public function generateXlsx()
    {
        $gs = Generalsetting::first();
        $data = [
            'title' => $gs->title,
            'date' => date('Y-m-d'),
            'from' => request('from'),
            'to' => request('to'),
        ];

        request()->validate([
            'from' => 'required|date',
            'to' => 'required|date',
        ]);

        $data['transactions'] = Transaction::query()
            ->whereBetween(DB::raw('DATE(created_at)'), [request('from'), request('to')])
            ->whereUserId(auth()->id())
            ->orderBy('id', 'desc')
            ->get();

        return Excel::download(new StatementExport($data), uniqid('transaction-') . '.xlsx', \Maatwebsite\Excel\Excel::XLSX);
    }

    public function profile()
    {
        $user = auth()->user();
        return view('user.profile', compact('user'));
    }

    public function profileUpdate(Request $request)
    {
        $request->validate([
            'photo' => 'nullable|image|mimes:jpeg,jpg,png,svg|max:2048',
            'email' => 'required|email|unique:users,email,' . Auth::id() . ',id',
        ]);

        $input = $request->all();
        $data = Auth::user();
        if ($file = $request->file('photo')) {
            $name = time() . $file->getClientOriginalName(); 

            storeScaleDownImage($file, 'images', $name);
            //$file->storeAs('images', $name, 'assets');

            Storage::disk('assets')->delete('images/' . $data->photo);

            $input['photo'] = $name;
            $input['is_provider'] = 0;
        }

        $data->update($input);
        $msg = 'Successfully updated your profile';
        return redirect()->back()->with('success', $msg);
    }

    public function changePasswordForm()
    {
        return view('user.changepassword');
    }

    public function changePassword(Request $request)
    {
        $user = Auth::user();
        if ($request->cpass) {
            if (Hash::check($request->cpass, $user->password)) {
                if ($request->newpass == $request->renewpass) {
                    $input['password'] = Hash::make($request->newpass);
                } else {
                    return redirect()->back()->with('unsuccess', 'Confirm password does not match.');
                }
            } else {
                return redirect()->back()->with('unsuccess', 'Current password Does not match.');
            }
        }
        $user->update($input);
        return redirect()->back()->with('success', 'Password Successfully Changed.');
    }

    // public function showTwoFactorForm_old()
    // {
    //     $gnl = Generalsetting::first();
    //     $ga = new GoogleAuthenticator();
    //     $user = auth()->user();
    //     $secret = $ga->createSecret();
    //     $qrCodeUrl = $ga->getQRCodeGoogleUrl($gnl->title, $secret);
    //     // $prevcode = $user->tsc;
    //     $prevcode = "";
    //     $prevqr = $ga->getQRCodeGoogleUrl($user->name . '@' . $gnl->title, $prevcode);

    //     return view('user.twofactor.index', compact('secret', 'qrCodeUrl', 'prevcode', 'prevqr', 'user'));
    // }

    public function showTwoFactorForm()
    {
        $gnl = Generalsetting::first();
        $ga = new GoogleAuthenticator();
        $user = auth()->user();

        // Generate new secret and QR
        $secret = $ga->createSecret();
        $qrCodeUrl = $ga->getQRCodeGoogleUrl($user->name . '@' . $gnl->title, $secret);

        // Optionally store the new secret temporarily
        session(['new_2fa_secret' => $secret]);

        // Handle previous QR only if tsc exists
        $prevcode = $user->tsc;
        $prevqr = null;
        if ($prevcode) {
            $prevqr = $ga->getQRCodeGoogleUrl($user->name . '@' . $gnl->title, $prevcode);
        }

        return view('user.twofactor.index', compact('secret', 'qrCodeUrl', 'prevcode', 'prevqr', 'user'));
    }


    public function createTwoFactor(Request $request)
    {
        try {
            $user = auth()->user();

            $this->validate($request, [
                'key' => 'required',
                'code' => 'required',
            ]);

            $ga = new GoogleAuthenticator();
            $secret = $request->key;
            $oneCode = $ga->getCode($secret);

            if ($oneCode == $request->code) {
                $user->go = $request->key;
                $user->twofa = 1;
                $user->verified = 1;
                $user->save();

                session(['2fa_verified_google' => true]); //new addedd

                return redirect()->route('user.dashboard')->with('success', 'Two factor authentication activated');
            } else {
                return redirect()->back()->with('error', 'Something went wrong!');
            }
        } catch (Exception $th) {
            dd($th);
        }
    }


    public function disableTwoFactor(Request $request)
    {

        $this->validate($request, [
            'code' => 'required',
        ]);

        $user = auth()->user();
        $ga = new GoogleAuthenticator();

        $secret = $user->go;
        $oneCode = $ga->getCode($secret);
        $userCode = $request->code;

        if ($oneCode == $userCode) {

            $user->go = null;
            $user->twofa = 0;

            $user->save();

            return redirect()->back()->with('success', 'Two factor authentication disabled');
        } else {
            return redirect()->back()->with('error', 'Something went wrong!');
        }
    }

    public function username($number, $type = null)
    {
        if ($data = User::where('account_number', $number)->first()) {
            if($type == 'send_money'){

                $bank_plan = BankPlan::whereId(auth()->user()->bank_plan_id)->first();
                $charge = $bank_plan->getSendMoneyCharge($data);
                return response()->json(['name' => $data->name. " " ." (".ucFirst($data->account_type).")", 'fixed' => $charge->fixed, 'percent' => $charge->percent]);
            }elseif($type == 'send_request_money'){

                $gs = Generalsetting::first();
                return response()->json(['name' => $data->name. " " ." (".ucFirst($data->account_type).")", 'fixed' => $gs->fixed_request_charge, 'percent' => $gs->percentage_request_charge]);
            }else{

                return $data->name;
            }
        } else {
            return false;
        }
    }

    public function affilate_code()
    {
        $user = Auth::guard('web')->user();
        return view('user.affilate_code', compact('user'));
    }

    public function sendVerifyOtpToPhone(Request $request)
    {
        auth()->user()->update(['phone' => $request->phone]);

        $otp = Otp::digits(6)->expiry(10)->generate($request->phone);

        //  dd("otp");

        $textMessage = "Your OTP is $otp";
        send_sms([$request->phone, $textMessage]);
        Log::info($textMessage);

        return view('includes.user.fragments.verify_phone_otp', [
            'otpSent' => true,
        ])->fragment('verify-form');
    }

    public function verifyPhoneOtp(Request $request)
    {
        $phoneNumber = auth()->user()->phone;

        $verified = Otp::check($request->otp, $phoneNumber);

        $fragment = $verified ? 'verify-response' : 'verify-form';

        if ($verified) {
            auth()->user()->update(['phone_verified_at' => now()]);
        }

        return view('includes.user.fragments.verify_phone_otp', [
            'verified' => $verified,
        ])->fragment($fragment);
    }

    public function sendVerifyOtpToEmail(Request $request)
    {
        $user = auth()->user();

        Mail::send([], [], function ($message) use ($user) {
            $otp = Otp::digits(6)->expiry(10)->generate($user->email);
            $emailBody = "Dear $user->name,\nYour OTP for the email verification is $otp.\nDo not share this OTP with anyone.\nThank you";
            $message->to($user->email);
            $message->subject('Email Verification');
            $message->html(nl2br($emailBody));
            Log::info($emailBody);
        });

        return view('includes.user.fragments.verify_email_otp', [
            'otpSent' => true,
        ])->fragment('verify-form');
    }

    public function verifyEmailOtp(Request $request)
    {
        $emailAddress = auth()->user()->email;

        $verified = Otp::check($request->otp, $emailAddress);

        $fragment = $verified ? 'verify-response' : 'verify-form';

        if ($verified) {
            auth()->user()->update(['email_verified_at' => now()]);
        }

        return view('includes.user.fragments.verify_email_otp', [
            'verified' => $verified,
        ])->fragment($fragment);
    }

    public function enableDisable2fa(Request $request)
    {
        $user = auth()->user();
        $fragment = 'enable-email-2fa-form';

        $isValidOtp = false;
        $otpSent = false;
        if ($request->action == 'verify-email-otp') {
            $request->validate(['otp' => 'required|digits:6']);

            $isValidOtp = Otp::digits(6)->check($request->otp, $user->email);

            if ($isValidOtp) {
                $user->email_2fa = $request->disable == 1 ? 0 : 1;
                $user->save();
            } else {
                $fragment = $request->disable == 1 ? 'disable-email-2fa' : 'enable-email-2fa';
            }
        }
        if ($request->action == 'enable-email-2fa' || $request->action == 'disable-email-2fa') {
            $fragment = $request->action;
            Mail::send([], [], function ($message) use ($user) {
                $otp = Otp::digits(6)->expiry(10)->generate($user->email);
                $emailBody = "Dear $user->name,\nYour OTP for the email verification is $otp.\nDo not share this OTP with anyone.\nThank you";
                $message->to($user->email);
                $message->subject('2FA Email Verification');
                $message->html(nl2br($emailBody));
                Log::info($emailBody);
            });
            $otpSent = true;
        }

        return view('includes.user.fragments.enable_email_2fa', [
            'user' => auth()->user(),
            'otpSent' => $otpSent,
            'otpVerified' => $request->action == 'verify-email-otp' && $isValidOtp,
            'disabled' => $request->disable == 1
        ])->fragment($fragment);
    }

    public function verify2faEmail(Request $request)
    {
        if ($request->isMethod('POST')) {
            $request->validate([
                'otp' => 'required|digits:6',
            ]);

            $isValid = Otp::check($request->otp, Auth::guard('web')->user()->email);

            if ($isValid) {
                $user = auth()->user();
                $user->email_2fa = 1;
                $user->save();
                session(['2fa_' . md5(auth()->id()) => true]);
                return to_route('user.dashboard');
            }



            return back()->withErrors(['otp' => 'The OTP is invalid.']);
        }

        return view('user.2fa-verify.email');
    }

    public function resendVerifyOtpEmail()
    {
        Mail::send([], [], function ($message) {
            $user = Auth::guard('web')->user();
            $otp = Otp::digits(6)->expiry(10)->generate($user->email);
            $emailBody = "Dear $user->name,\nYour OTP for the 2FA verification is $otp.\nDo not share this OTP with anyone.\nThank you";
            $message->to($user->email);
            $message->subject('2FA OTP Verification');
            $message->html(nl2br($emailBody));
            Log::info($emailBody);
        });

        return back()->with('success', 'OTP Sent Successfully');
    }

    public function verify2faApp()
    {
        return view('user.twofactor.verify');
        // return $this->showTwoFactorForm();
        // return view('user.twofactor.index', $user);
        //  return back()->with('success', 'Verify 2Fa App  Successfully');
    }

    public function Email2fa(User $user, string $status)
    {
        if ($status == 'enable') {
            return to_route('user.2fa.verify.email');
            //  $user->email_2fa = 1;
        } else {
            $user->email_2fa = 0;
            $user->save();
        }


        return back()->with('success', "Email 2FA $status successfully.");
    }

    public function otherUser()
    {
        return view('user.otherUser');
    }

    public function userPaymentQr()
    {
        $user = auth()->user();
        $data['gs'] = Generalsetting::first();
        $qrCode = new QrCode(
            data: $user->account_number,
            encoding: new Encoding('UTF-8'),
            size: 150,
            margin: 10,
            foregroundColor: new Color(0, 0, 0),
            backgroundColor: new Color(255, 255, 255),
        );

        $writer = new PngWriter();
        $result = $writer->write($qrCode);

        $data['qrImage'] = $result->getDataUri();

        return view('user.userPaymentQr', $data);
    }

    public function downloadQr()
    {
        $user = auth()->user();
        $gs = Generalsetting::first();

        $qrCode = new QrCode(
            data: $user->account_number,
            encoding: new Encoding('UTF-8'),
            size: 150,
            margin: 10,
            foregroundColor: new Color(0, 0, 0),
            backgroundColor: new Color(255, 255, 255),
        );

        $writer = new PngWriter();
        $result = $writer->write($qrCode);

        $qrImage = $result->getDataUri();

        $pdf = Pdf::loadView('user.qr-pdf', compact('user', 'qrImage', 'gs'))
                ->setPaper('a4', 'portrait');

        return $pdf->download('qr_'.$user->account_number.'.pdf');

    }

    public function otherUserDatatable(Request $request)
    {

        if ($request->ajax()) {
            $data = User::query()->whereIn('account_type', ['agent', 'merchant'])
                ->where('id', '!=', auth()->id())
                ->latest();

            return DataTables::eloquent($data)
                ->editColumn('account_type', function (User $data) {
                    return ucwords($data->account_type);
                })
                ->editColumn('phone', function (User $data) {
                    return preg_replace("/[^0-9+]/", "", $data->phone);
                })
                ->editColumn('city', function (User $data) {
                    return $data->city . '(' . $data->zip . ')';
                })
                // ->editColumn('telegram', function (User $data) {
                //     return $data->telegram;
                // })
                ->editColumn('account_number', function (User $data) {
                    return $data->account_number;
                })


                ->filterColumn('name', function ($query, $keyword) {
                    $query->where('name', 'like', "%{$keyword}%");
                })
                ->filterColumn('email', function ($query, $keyword) {
                    $query->where('email', 'like', "%{$keyword}%");
                })
                ->filterColumn('city', function ($query, $keyword) {
                    // $query->where('city', 'like', "%{$keyword}%");
                    $query->where(function ($q) use ($keyword) {
                        $q->where('city', 'like', "%{$keyword}%")
                            ->orWhere('zip', 'like', "%{$keyword}%");
                    });
                })
                ->filterColumn('account_number', function ($query, $keyword) {
                    $query->where('account_number', 'like', "%{$keyword}%");
                })

                ->filterColumn('telegram', function ($query, $keyword) {
                    $query->where('telegram', 'like', "%{$keyword}%");
                })
                ->filterColumn('account_type', function ($query, $keyword) {
                    $query->where('account_type', 'like', "%{$keyword}%");
                })

                ->toJson();
        }
    }



    public function prompt()
    {
        return view('user.location.index');
    }

    public function reverseGeocode(Request $request)
    {
        $request->validate([
            'latitude' => 'required|numeric',
            'longitude' => 'required|numeric',
        ]);

        $lat = $request->latitude;
        $lon = $request->longitude;

        session([
            'user_latitude' => $lat,
            'user_longitude' => $lon,
        ]);

        $response = Http::withHeaders([
            'User-Agent' => 'MyBangladeshApp/1.0 (your@email.com)' // Required by Nominatim
        ])->get('https://nominatim.openstreetmap.org/reverse', [
            'format' => 'json',
            'lat' => $lat,
            'lon' => $lon,
        ]);
        $data = $response->json();
        $city = $data['address']['county']   . ',' . $data['address']['city']
            ?? $data['address']['town']
            ?? $data['address']['village']
            ?? null;

        $user = storeUserLog(request()->header('User-Agent'), request()->ip(),  auth()->user()->id);
        $user->latitude = $lat;
        $user->longitude = $lon;
        $user->city = $city;
        $user->save();
        return redirect()->route('user.dashboard');
    }

    public function userNotifications()
    {
        if (request()->ajax()) {
            $notifications = CustomerNotification::with('user')->where('receiver_id', auth()->id())->orderBy('id', 'desc');

            return DataTables::eloquent($notifications)
                ->addIndexColumn()
                ->editColumn('details_data', function ($row) {
                    $new = '';
                    if (!$row->read_at) {
                        $new = '<div class="badge badge-success">New</div>';
                    }
                    return $row->data . ' ' . $new;
                })
                ->editColumn('date_data', function ($row) {
                    return Carbon::parse($row->created_at)?->diffForHumans();
                })
                ->addColumn('route', function ($row) {
                    return $row->route;
                })
                ->addColumn('action', function ($row) {
                    $markAsReadUrl = route('user.notifications.mark.read',$row->id);

                    $markAsReadBtn = "";
                    if (!$row->read_at) {
                        $markAsReadBtn = "<a href=\"$markAsReadUrl\" class=\"btn btn-primary btn-sm btn-rounded\">Mask as Read</a>";
                    }
                    $goToBtn = "";
                    $goToUrl = route($row->route);
                    if ($goToUrl != '#') {
                        $goToBtn = "<a href=\"$goToUrl\" class=\"btn btn-primary btn-sm btn-rounded\">Go to</a>";
                    }
                    return "$markAsReadBtn $goToBtn";
                })
                ->rawColumns(['details_data', 'action'])
                ->toJson();
        }
        return view('user.notifications');
    }

    public function userNotificationRead($id)
    {
        $notifications = CustomerNotification::find($id);
        if ($notifications && $notifications->receiver_id == auth()->user()->id) {
            $notifications->read_at = Carbon::now();
            $notifications->save();
            return back()->with('success', 'Notification marked as read.');
        }
        return back()->with('error', 'Notification not found.');
    }
}
