<?php

namespace App\Http\Middleware;

use Auth;
use Closure;
use Illuminate\Http\Request;

class BanUser
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check() && Auth::user()->is_banned == 1 ) {
            Auth::guard('web')->logout();
            return redirect()->route('user.login')->with('warning', 'Your account has been suspended!');
        }
        return $next($request);
    }
}
