<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class LoanMissedInstallment extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_loan_id',
        'user_id',
        'transaction_no',
        'amount',
        'installment_number',
        'due_date',
        'missed_date',
        'is_paid',
        'paid_date',
        'notes',
    ];

    protected $casts = [
        'due_date' => 'datetime',
        'missed_date' => 'datetime',
        'paid_date' => 'datetime',
        'is_paid' => 'boolean',
    ];

    public function userLoan()
    {
        return $this->belongsTo(UserLoan::class)->withDefault();
    }

    public function user()
    {
        return $this->belongsTo(User::class)->withDefault();
    }

    /**
     * Scope to get unpaid missed installments
     */
    public function scopeUnpaid($query)
    {
        return $query->where('is_paid', false);
    }

    /**
     * Scope to get paid missed installments
     */
    public function scopePaid($query)
    {
        return $query->where('is_paid', true);
    }

    /**
     * Scope to get missed installments for a specific loan
     */
    public function scopeForLoan($query, $loanId)
    {
        return $query->where('user_loan_id', $loanId);
    }

    /**
     * Scope to get missed installments for a specific user
     */
    public function scopeForUser($query, $userId)
    {
        return $query->where('user_id', $userId);
    }
}
