<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasVersion4Uuids;
use Illuminate\Database\Eloquent\Model;

class PaymentRequest extends Model
{
    use HasVersion4Uuids;

    protected $fillable = [
        'merchant_id',
        'request_id',
        'amount',
        'currency',
        'customer_data',
        'metadata',
        'description',
        'return_url',
        'cancel_url',
        'webhook_url',
        'referrer',
    ];

    protected $casts = [
        'customer_data' => 'array',
        'metadata' => 'array',
    ];
}
