<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Role extends Model
{
    protected $fillable = ['name', 'section', 'register_id', 'preloaded'];

    public $timestamps = false;

    public function admins(): HasMany
    {
        return $this->hasMany('App\Models\Admin');
    }

    public function sectionCheck($value): bool
    {
        $sections = explode(" , ", $this->section);
        if (in_array($value, $sections)) {
            return true;
        } else {
            return false;
        }
    }
}
