<?php

namespace App\Providers;

use App\Models\AdminLanguage;
use App\Models\Currency;
use App\Models\Font;
use App\Models\Generalsetting;
use App\Models\Language;
use App\Models\Page;
use App\Models\Pagesetting;
use App\Models\Seotool;
use App\Models\Socialsetting;
use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Http\Request;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void {}

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });

        try {
            $settings = DB::table('generalsettings')->first();
            $seo = DB::table('seotools')->first();
            if ($settings && $settings->is_smtp) {
                Config::set('mail.mailers.smtp.host', $settings->smtp_host);
                Config::set('mail.mailers.smtp.port', $settings->smtp_port);
                Config::set('mail.mailers.smtp.encryption', $settings->smtp_encryption);
                Config::set('mail.mailers.smtp.username', $settings->smtp_user);
                Config::set('mail.mailers.smtp.password', $settings->smtp_pass);
                Config::set('mail.from.address', $settings->from_email);
                Config::set('mail.from.name', $settings->from_name);

                Config::set('services.facebook.pixel_id', $seo->facebook_pixel_id);
                Config::set('services.gtm.id', $seo->gtm_id);
            }
        } catch (\Exception $e) {
            // Fail silently if DB not ready (like in migrations)
        }

        view()->composer('*', function ($view) {
            //$settings->with('seo', DB::table('seotools')->first());
            //$settings->with('gs', DB::table('generalsettings')->first());
            //$settings->with('pages', DB::table('pages')->whereStatus(1)->get());
            //$settings->with('ps', DB::table('pagesettings')->first());
            //$settings->with('social', DB::table('socialsettings')->first());
            //$settings->with('defaultCurrency', Session::get('currency') ?  DB::table('currencies')->where('id','=',Session::get('currency'))->first() : DB::table('currencies')->where('is_default','=',1)->first());
            $view->with('seo', Seotool::first());
            $view->with('gs', Generalsetting::first());
            $view->with('pages', Page::whereStatus(1)->get());
            $view->with('ps', Pagesetting::first());
            $view->with('social', Socialsetting::first());
            $view->with('default_font', Font::where('is_default', '=', 1)->first());
            $view->with('defaultCurrency', Session::get('currency') ? Currency::where('id', '=', Session::get('currency'))->first() : Currency::where('is_default', '=', 1)->first());

            if (\Request::is('admin') || \Request::is('admin/*')) {
                //$data = DB::table('admin_languages')->where('is_default','=',1)->first();
                $data = AdminLanguage::where('is_default', '=', 1)->first();
                App::setlocale($data->name);
            } else {
                if (Session::has('language')) {
                    //$data = DB::table('languages')->find(Session::get('language'));
                    $data = Language::find(Session::get('language'));
                    App::setlocale($data->name);
                } else {
                    //$data = DB::table('languages')->where('is_default','=',1)->first();
                    $data = Language::where('is_default', '=', 1)->first();
                    App::setlocale($data->name);
                }
            }

            if (Session::has('currency')) {
                //$data = DB::table('currencies')->find(Session::get('currency'));
                $data = Currency::find(Session::get('currency'));
                $view->with('currency', $data);
            } else {
                //$data = DB::table('currencies')->where('is_default','=',1)->first();
                $data = Currency::where('is_default', '=', 1)->first();
                $view->with('currency', $data);
            }

            $view->with('isImpersonation', (bool)session('admin.impersonated_user_id'));
        });
        Paginator::useBootstrap();
    }
}
