<?php

use Illuminate\Http\Request;
use App\Jobs\DpsCollectionJob;
use App\Jobs\MaturedFdrProfit;
use App\Jobs\ProcessLoanInstallments;
use Illuminate\Support\Facades\Route;
use App\Jobs\CancelPendingDepositsJob;
use Illuminate\Foundation\AliasLoader;
use Illuminate\Foundation\Application;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        commands: base_path('routes/console.php'),
        health: '/up',
        then: function () {
            $namespace = 'App\\Http\\Controllers';
            Route::namespace($namespace)->group(function () {
                Route::middleware('api')
                    ->prefix('api')->group(base_path('routes/api.php'));
                Route::middleware('web')->group(base_path('routes/payment.php'));
                Route::middleware('web')->group(base_path('routes/web.php'));
                Route::middleware('web')->group(base_path('routes/admin.php'));
                Route::middleware('web')->group(base_path('routes/user.php'));
            });
        }
    )
    ->withMiddleware(function (Middleware $middleware) {
        $excludedUrlCsrfTokens = require __DIR__.'/excluded_url_csrf.php';
        $middleware->validateCsrfTokens($excludedUrlCsrfTokens);
        $middleware->use([
            Illuminate\Foundation\Http\Middleware\InvokeDeferredCallbacks::class,
            // Illuminate\Http\Middleware\TrustHosts::class,
            Illuminate\Http\Middleware\TrustProxies::class,
            Illuminate\Http\Middleware\HandleCors::class,
            App\Http\Middleware\PreventRequestsDuringMaintenance::class,
            Illuminate\Http\Middleware\ValidatePostSize::class,
            Illuminate\Foundation\Http\Middleware\TrimStrings::class,
            Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class
        ]);
        
        // Add maintenance mode check to web middleware group (after session is started)
        $middleware->web(append: [
            App\Http\Middleware\CheckMaintenanceMode::class
        ]);
        
        $middleware->alias([
            // 'auth' => \App\Http\Middleware\Authenticate::class,
            // 'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
            'permissions' => App\Http\Middleware\Permissions::class,
            'banuser' => App\Http\Middleware\BanUser::class,
            'setapi' => App\Http\Middleware\SetApiGuard::class,
            'otp' => App\Http\Middleware\Otp::class,
            '2fa' => App\Http\Middleware\Verify2FA::class,
            'kyc' => App\Http\Middleware\KYC::class,
            'check_suspended' => App\Http\Middleware\UserSuspended::class,
            'check_ip' => App\Http\Middleware\CheckUserIp::class,
            'check_location' => \App\Http\Middleware\CheckLocation::class,
        ]);
        $middleware->redirectGuestsTo(function (Request $request) {
            if ($request->expectsJson()) {
                return response(['error' => 'Unauthenticated.'], 401);
            }
            if ($request->is('admin') || $request->is('admin/*')) {
                return '/admin/login';
            }
            if ($request->is('user') || $request->is('user/*')) {
                return '/user/login';
            }
            return route('front.index');
        });
        $middleware->redirectUsersTo(function (Request $request) {
            if ($request->is('admin') || $request->is('admin/*')) {
                if (auth('admin')->check()) return '/admin/dashboard';
            }
            return '/user/dashboard';
        });
    })
    ->withExceptions(function (Exceptions $exceptions) {
        $exceptions->dontFlash([
            'current_password',
            'password',
            'password_confirmation',
        ]);
    })
    ->withSchedule(function (Schedule $schedule) {
        $schedule->job(CancelPendingDepositsJob::class)->everyMinute();
        $schedule->job(DpsCollectionJob::class)->everyMinute();
        $schedule->job(MaturedFdrProfit::class)->everyMinute();
        $schedule->job(ProcessLoanInstallments::class)->everyMinute();
    })
    ->booting(function () {
        $loader = AliasLoader::getInstance();
        $aliases = require __DIR__.'/aliases.php';

        foreach ($aliases as $alias => $class) {
            $loader->alias($alias, $class);
        }
    })
    ->create();
