<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_merchants', function (Blueprint $table) {
            $table->id();
            $table->string('user_id');
            $table->string('merchant_id');
            $table->string('merchant_logo')->nullable();;
            $table->string('public_key')->nullable();
            $table->string('secret_key')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_merchants');
    }
};
