<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('socialsettings', function (Blueprint $table) {
            $table->string('youtube')->nullable();
            $table->tinyInteger('yt_status')->default(1);
            $table->string('instagram')->nullable();
            $table->tinyInteger('insta_status')->default(1);
            $table->string('telegram')->nullable();
            $table->tinyInteger('tlg_status')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('socialsettings', function (Blueprint $table) {
             $table->dropColumn(['youtube', 'instagram', 'telegram', 'yt_status', 'insta_status', 'tlg_status', ]);
        });
    }
};
