<?php

use App\Models\EmailTemplate;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    public function up(): void
    {
        
        if (!Schema::hasColumn('users', 'last_name')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('last_name')->nullable()->after('name');
            });
        }

        if (!Schema::hasColumn('users', 'timezone')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('timezone')->default('UTC')->after('last_name');
            });
        }

        if (!Schema::hasColumn('generalsettings', 'min_withdraw_point')) {
            Schema::table('generalsettings', function (Blueprint $table) {
                $table->string('min_withdraw_point')->nullable()->after('point_total_user');
            });
        }

        if (!Schema::hasColumn('generalsettings', 'max_withdraw_point')) {
            Schema::table('generalsettings', function (Blueprint $table) {
                $table->string('max_withdraw_point')->nullable()->after('min_withdraw_point');
            });
        }

        if (!Schema::hasColumn('admin_user_conversations', 'is_read_admin')) {
            Schema::table('admin_user_conversations', function (Blueprint $table) {
                $table->integer('is_read_admin')->nullable();
            });
        }

        if (!Schema::hasColumn('generalsettings', 'maintenance_mode')) {
            Schema::table('generalsettings', function (Blueprint $table) {
                $table->boolean('maintenance_mode')->default(false)->after('is_location_active');
            });
        }

        $emailtemps = [
            'loan' => [
                'subject' => 'Loan Applied',
                'body' => '<p>Hello {customer_name},<br>Your withdrawal request is processed.</p><p>Thank You<br></p>',
            ],
            'dps' => [
                'subject' => 'DPS Applied',
                'body' => '<p>Hello {customer_name},<br>Your deposit was successful.</p><p>Thank You<br></p>',
            ],
            'fdr' => [
                'subject' => 'FDR Applied',
                'body' => '<p>Hello {customer_name},<br>Your deposit was successful.</p><p>Thank You<br></p>',
            ],
            'other bank' => [
                'subject' => 'Other Bank Transfer',
                'body' => '<p>Hello {customer_name},<br>Your Other Bank Transfer Deposite was successful.</p><p>Thank You<br></p>',
            ],
            'bank plan pricing' => [
                'subject' => 'Bank Plan Pricing Submitted',
                'body' => '<p>Hello {customer_name},<br>Your deposit was successful.</p><p>Thank You<br></p>',
            ],
            'bonus withdraw' => [
                'subject' => 'Bonus Withdraw Confirmed',
                'body' => '<p>Hello {customer_name},<br>Your deposit was successful.</p><p>Thank You<br></p>',
            ],
            'wire transfer' => [
                'subject' => 'Deposit Confirmed',
                'body' => '<p>Hello {customer_name},<br>Your deposit was successful.</p><p>Thank You<br></p>',
            ],
        ];


        if (Schema::hasTable('email_templates')) {
            foreach ($emailtemps as $email_type => $content) {
                EmailTemplate::updateOrCreate(
                    ['email_type' => $email_type],
                    [
                        'email_type' => $email_type,
                        'email_subject' => $content['subject'],
                        'email_body' => $content['body'],
                        'status' => 1,
                    ]
                );
            }
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('users', 'last_name')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('last_name');
            });
        }

        if (Schema::hasColumn('users', 'timezone')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('timezone');
            });
        }

        if (Schema::hasColumn('users', 'min_withdraw_point')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('min_withdraw_point');
            });
        }

        if (Schema::hasColumn('users', 'max_withdraw_point')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('max_withdraw_point');
            });
        }

        if (Schema::hasColumn('generalsettings', 'maintenance_mode')) {
            Schema::table('generalsettings', function (Blueprint $table) {
                $table->dropColumn('maintenance_mode');
            });
        }
    }
};