<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('loan_missed_installments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_loan_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->string('transaction_no')->nullable();
            $table->decimal('amount', 20, 2)->nullable();
            $table->integer('installment_number')->nullable();
            $table->timestamp('due_date')->nullable();
            $table->timestamp('missed_date')->nullable();
            $table->boolean('is_paid')->default(false);
            $table->timestamp('paid_date')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
        });

        // Add missed_installment_count column to user_loans table
        if (!Schema::hasColumn('user_loans', 'missed_installment_count')) {
            Schema::table('user_loans', function (Blueprint $table) {
                $table->integer('missed_installment_count')->default(0)->after('given_installment');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('loan_missed_installments');
        
        if (Schema::hasColumn('user_loans', 'missed_installment_count')) {
            Schema::table('user_loans', function (Blueprint $table) {
                $table->dropColumn('missed_installment_count');
            });
        }
    }
};
