<table class="table" style="min-height: 300px;">
    <tr>
        <td>Customer Name</td>
        <td>{{ $deposit->user->name }}</td>
    </tr>
    <tr>
        <td>Customer Email</td>
        <td>{{ $deposit->user->email }}</td>
    </tr>
    <tr>
        <td>Amount</td>
        <td>
            {{ amount_format($deposit->amount) }} {{ $defCurrency->name }}
            <br>
            <small>
                {{ amount_format($deposit->amount * $deposit->rate) }} {{ $depositCurrency->name }}
                [Rate: {{ $deposit->rate }} {{ $depositCurrency->name }}]
            </small>
        </td>
    </tr>
    <tr>
        <td>Date</td>
        <td>{{ $deposit->created_at?->format('M d, Y H:i') }}</td>
    </tr>
    <tr>
        <td>Deposit Number</td>
        <td>{{ $deposit->deposit_number }}</td>
    </tr>
    <tr>
        <td>Gateway</td>
        <td>
            @php($gateway = $deposit->gateway)
            @if($gateway)
                {{ $gateway->name ?? $gateway->title }}
                @if($deposit->method=='Manual')
                    ({{$deposit->method}})
                @endif
            @else
                {{ ucwords($deposit->method) }}
            @endif
        </td>
    </tr>
</table>
@if(!empty($deposit->additional_data))
    <h6 class="font-weight-bold">Additional Information</h6>
@endif
<table class="table w-100">
    @foreach($deposit->additional_data ?? [] as $key => $additional)
        @php($_title = ucwords(str_replace('_', ' ', $key)))
        @isset($additional['file'])
            <tr class="border-0">
                <td class="pb-0 border-0">{{ $_title }}</td>
            </tr>
            <tr class="border-0">
            <td class="p-0">
                <a href="{{ $deposit->fileUrl($additional['file']) }}" target="_blank">
                    <img src="{{ $deposit->fileUrl($additional['file']) }}" 
                        alt="{{ $_title }}" 
                        class="img-fluid w-100" 
                        style="min-height: 300px"/>
                </a>
            </td>
        </tr>
        @endisset
        @isset($additional['value'])
            <tr class="border-0">
                <td class="pb-0 border-0">{{ $_title }}</td>
            </tr>
            <tr class="border-0">
                <td class="pt-0">{{ $additional['value'] }}</td>
            </tr>
        @endisset
    @endforeach
</table>
<div class="heading-area">
    <h4 class="title">
        {{__('Status Change Logs')}}
    </h4>
</div>

<div class="table-responsive show-table">
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>SL</th>
                <th>Name</th>
                <th>Prev Status</th>
                <th>Current Status</th>
                <th>Time</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($deposit->histories as $key=>$item)
                <tr>
                    <td>{{ $key+1 }}</td>
                    <td>{{ optional($item->admin)->name }}</td>
                    <td>{{ ucFirst($item->privious_status) }}</td>
                    <td>{{ ucFirst($item->current_status) }}</td>
                    <td>{{ $item->created_at }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>