@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Balance Report') }}</h5>
            <ol class="breadcrumb m-0 py-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Balance Report') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-light">
                    <h5 class="mb-0">{{ __('Customer Financial Summary') }}</h5>
                </div>
                <div class="card-body p-0">
                    <table class="table table-bordered mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th>{{ __('Description') }}</th>
                                <th class="text-right">{{ __('Amount') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $totals = [
                                    'Total Customer Balance'                    => ['value' => $usersTotalBalance, 'sign' => '-'],
                                    'Total Customer Dps'                        => ['value' => $dpsamount, 'sign' => '-'],
                                    'Total Customer Fdr'                        => ['value' => $fdramount, 'sign' => '-'],
                                    'Total Customer Loan'                       => ['value' => $loanamount, 'sign' => '+'],
                                    'Total Withdraw Pending'                    => ['value' => $withdrawPendingAmount, 'sign' => '-'],
                                    'Total Other Bank Pending Amount'           => ['value' => $otherBankPending, 'sign' => '-'],
                                    'Total Wire Transfer Pending Amount'        => ['value' => $wireTransferPending, 'sign' => '-'],
                                    'Total Bonus Point Amount'                  => ['value' => $bonusPointAmount, 'sign' => '-'],
                                ];

                                $subtotal = 0;
                                foreach($totals as $t) {
                                    $subtotal += ($t['sign'] === '+') ? $t['value'] : -$t['value'];
                                }
                            @endphp

                            @foreach ($totals as $label => $t)
                                <tr>
                                    <td>{{ __($label) }}</td>
                                    <td class="text-right">
                                        @if($t['sign'] === '-')
                                            - {{ amount_format(abs($t['value'])) }} {{ $currency->name }}
                                        @else
                                            {{ amount_format($t['value']) }} {{ $currency->name }}
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="font-weight-bold">
                            <tr>
                                <td class="text-uppercase">{{ __('Total') }}</td>
                                <td class="text-right">
                                    @if($subtotal < 0)
                                        - {{ amount_format(abs($subtotal)) }} {{ $currency->name }}
                                    @else
                                        {{ amount_format($subtotal) }} {{ $currency->name }}
                                    @endif
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection