@extends('layouts.admin')

@section('content')

    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class="mb-0 text-gray-800 pl-3">{{ __('Admin Transaction') }}</h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a
                        href="{{ route('admin.user.admin.transaction') }}">{{ __('Admin Transaction') }}</a></li>
            </ol>
        </div>
    </div>

    <!-- Row -->
    <div class="row mt-3">
        <div class="col-lg-12">
            <div class="card mb-4">
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover dt-responsive nowrap" cellspacing="0" width="100%">
                        <thead class="thead-light">
                        <tr>
                            <th>{{ __("#") }}</th>
                            <th>{{ __("Name") }}</th>
                            <th>{{ __("Phone") }}</th>
                            <th>{{ __("Type") }}</th>
                            <th>{{ __("Added Amount") }}</th>
                            <th>{{ __("Subtracted Amount") }}</th>
                            <th>{{ __("Date") }}</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('scripts')
    <script type="text/javascript">
        'use strict';

        var table = $('#geniustable').DataTable({
            ordering: false,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: '{{ route('admin.user.admin.transaction') }}',
            columns: [
                {data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: false, orderable: false},
                {data: 'name', name: 'user.name'},
                {data: 'phone', name: 'user.phone'},
                {data: 'type', name: 'type'},
                {data: 'add_amount', name: 'add_amount'},
                {data: 'sub_amount', name: 'sub_amount'},
                {data: 'date', name: 'created_at'}
            ],
            language: {
                processing: '<img src="{{ asset('assets/images/'.$gs->admin_loader) }}">'
            }
        });
    </script>
@endsection
