<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Withdraw -</title>
    <style>
        * {
            font-family: sans-serif;
            font-size: 12px;
            padding: 0;
            margin: 0;
            outline: 0;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        table,
        th,
        td {
            border: 1px solid #4f4f4f;
            padding: 4px 5px;
            line-height: 1 !important;
        }

        .text-center {
            text-align: center;
        }

        .text-end {
            text-align: right;
        }

        .text-title {
            font-size: 1.5rem;
            padding-top: 5px
        }

        .text-subtitle {
            font-size: 1.25rem;
            padding-top: 5px
        }

        .w-1 {
            width: 1%;
        }
    </style>
</head>

<body>
    <div style="padding: 30px;">
        <div style="padding-bottom: 20px">
            <h2 class="text-center text-title">{{ $title }}</h2>
            <h4 class="text-center text-subtitle">Withdraw - </h4>
            {{-- <p class="text-center" style="font-size: 1.25rem; padding-top: 5px">Period: {{ request('from') }}
            to {{ request('to') }}</p> --}}
        </div>
        <table>
            <thead>
                <tr>
                    <th class="w-1 text-center">@lang('S/N')</th>
                    <th>@lang('Email')</th>
                    <th>@lang('Phone')</th>
                    <th>@lang('Method')</th>
                    <th>@lang('Amount')</th>
                    <th>@lang('Value')</th>
                    <th>@lang('Details')</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $total_amount = 0;
                    $total_value = 0;
                @endphp

                @forelse ($withdraws as $key => $data)
                    @php
                        $gateway = $data->gateway;
                        $currency_id = json_decode($gateway->currency_id);
                        $g_currency = App\Models\Currency::find($currency_id[0] ?? 0);
                        $convert_rate = $data->rate ?? $gateway->sending_rate;

                        $value = $gateway->type == 'manual'
                            ? round($data->amount * $convert_rate, 2)
                            : $data->amount;

                        $total_amount += $data->amount;
                        $total_value += $value;
                    @endphp

                    <tr>
                        <td class="w-1 text-center">
                            <span class="text-muted">{{ $loop->iteration }}</span>
                        </td>
                        <td>{{ $data->user->email ?? '-' }}</td>
                        <td>{{ $data->user->phone ?? '-' }}</td>
                        <td class="text-end">{{ $data->method }}</td>
                        <td class="text-end">{{ number_format($data->amount, 2) }}</td>
                        <td class="text-end">{{ number_format($value, 2) }}</td>
                        <td class="text-end">{{ $data->details }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted">@lang('NO DATA FOUND')</td>
                    </tr>
                @endforelse
            </tbody>

            @if ($withdraws->count() > 0)
                <tfoot>
                    <tr>
                        <th colspan="4" class="text-end">@lang('Total'):</th>
                        <th class="text-end">{{ number_format($total_amount, 2) }}</th>
                        <th class="text-end">{{ number_format($total_value, 2) }}</th>
                        <th></th>
                    </tr>
                </tfoot>
            @endif
        </table>

    </div>
</body>

</html>
