<x-htmx-alpine/>
<!-- Face Verification Component -->
<div class="form-group mb-3" x-data="{ showRecorder: false }">
    <label class="form-label required">{{__('Face Verification')}}</label>
    <div class="face-verification-container">
        <div class="text-center" x-show="!showRecorder">
            <p> Click on below button to start face verification process </p>
            <button type="button" class="btn btn-outline-info mx-auto" @click="showRecorder=true">
                Start Face Verification
            </button>
        </div>
        <div x-show="showRecorder" x-cloak id="video-record-container">
            <div class="text-center mb-3">
                <strong>To verify your face, please start recording your face
                    and say the following:</strong>
                <hr class="my-2">
                <div style="max-width: 800px; margin: 10px auto; line-height: 2;">
                    Hi, I am [Your Name] from [Your Country]. I am opening account in my company name
                    for my personal uses. I insure that only I will use this and If someone
                    scams me
                    with my ID in future, I am responsible for it
                </div>
                <hr class="my-2">
                <strong>After recording please upload the video.</strong>
                <hr class="my-2">
            </div>
            <div id="video-container" class="mb-3 d-flex justify-content-center ">
                <div style="max-width: 480px; max-height: 500px; aspect-ratio: 480/640"
                     class="position-relative">
                    <video id="video-preview" playsinline
                           style="width: 100%; height: 100%; aspect-ratio: 480/640; border-radius: 8px;"></video>
                    <div id="recording-indicator" style="display: none;">
                        <strong class="text-recording">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="currentColor">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                <path
                                    d="M8 5.072a8 8 0 1 1 -3.995 7.213l-.005 -.285l.005 -.285a8 8 0 0 1 3.995 -6.643z"/>
                            </svg>
                            RECORDING...
                        </strong>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-center gap-2 mb-3">
                <button type="button" id="start-recording" class="btn btn-outline-primary">
                    {{__('Start Recording')}}
                </button>
                <button type="button" id="stop-recording" class="btn btn-outline-danger" style="display: none;"
                        disabled>
                    {{__('Stop Recording')}}
                </button>
                <button type="button" id="upload-video" class="btn btn-success" style="display: none;">
                    {{__('Upload')}}
                </button>
            </div>
            <div id="recording-status" class="alert alert-info text-center"
                 style="display: none;">
                {{__('Please look directly at the camera and follow the instructions.')}}
            </div>
            <div id="countdown-timer" class="alert alert-warning"
                 style="display: none;"></div>
        </div>
        <div id="video-upload-container" style="display: none">
            <div class="d-flex justify-content-center">
                <div class="text-center" style="max-width: 500px; width: 100%;">
                    <div id="upload-status-text">Uploading: 0%</div>
                    <div class="progress border rounded-pill my-2" role="progressbar" style="height: 1.25rem">
                        <div class="progress-bar" id="upload-progress-bar" style="width: 50%">50%</div>
                    </div>
                    <div id="upload-status2-text">Video upload in progress...</div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('js')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Variables
            let stream = null;
            let mediaRecorder = null;
            let recordedChunks = [];
            let isRecording = false;
            let recordingTimer = null;
            let countdown = null;
            let MAX_RECORDING_TIME = 30; // seconds

            const videoPreview = document.getElementById('video-preview');
            const startBtn = document.getElementById('start-recording');
            const stopBtn = document.getElementById('stop-recording');
            const uploadBtn = document.getElementById('upload-video');
            const recordingStatus = document.getElementById('recording-status');
            const recordingIndicator = document.getElementById('recording-indicator');
            const countdownTimerEl = document.getElementById('countdown-timer');

            // Start recording button event
            startBtn.addEventListener('click', async () => {
                try {
                    // Request camera access
                    stream = await navigator.mediaDevices.getUserMedia({
                        video: {
                            width: {ideal: 480},
                            height: {ideal: 640},
                            facingMode: "user"
                        },
                        audio: true
                    });

                    // Show video preview
                    videoPreview.srcObject = stream;
                    videoPreview.muted = true;
                    await videoPreview.play();

                    // Configure MediaRecorder
                    mediaRecorder = new MediaRecorder(stream, {mimeType: 'video/webm'});

                    // Event handlers for MediaRecorder
                    mediaRecorder.ondataavailable = (event) => {
                        if (event.data.size > 0) {
                            recordedChunks.push(event.data);
                        }
                    };

                    mediaRecorder.onstop = () => {
                        // Create a blob from recorded chunks
                        const videoBlob = new Blob(recordedChunks, {type: 'video/webm'});

                        // Convert to base64 for form submission
                        const reader = new FileReader();
                        reader.readAsDataURL(videoBlob);
                        reader.onloadend = () => {
                            const base64data = reader.result;

                            // Show recorded video
                            videoPreview.srcObject = null;
                            videoPreview.src = URL.createObjectURL(videoBlob);
                            videoPreview.controls = true;
                            videoPreview.muted = false;
                        };

                        // Reset UI
                        stopBtn.disabled = true;
                        startBtn.disabled = false;
                        startBtn.textContent = '{{__('Record Again')}}';
                        recordingStatus.style.display = 'none';
                        recordingIndicator.style.display = 'none';
                        stopBtn.style.display = 'none';
                        uploadBtn.style.display = 'inline-block';

                        // Stop all tracks
                        stream.getTracks().forEach(track => track.stop());
                    };

                    // Start the countdown before recording
                    startCountdown();

                } catch (error) {
                    console.error('Error accessing camera:', error);
                    alert('{{__('Could not access camera. Please check permissions and try again.')}}');
                }
            });

            // Stop recording button event
            stopBtn.addEventListener('click', () => {
                if (mediaRecorder && isRecording) {
                    mediaRecorder.stop();
                    isRecording = false;
                    startBtn.style.display = 'inline-block';
                    clearInterval(recordingTimer);
                    clearInterval(countdown);
                }
            });

            uploadBtn.addEventListener('click', () => {
                const videoBlob = new Blob(recordedChunks, {type: 'video/webm'});

                if (!videoBlob) {
                    alert('No video found. Please record a video and try again.');
                    return;
                }

                const recordContainer = document.getElementById('video-record-container');
                const uploadContainer = document.getElementById('video-upload-container');
                const progressBar = document.getElementById('upload-progress-bar');
                const uploadStatus = document.getElementById('upload-status-text');
                const uploadStatus2 = document.getElementById('upload-status2-text');

                recordContainer.style.display = 'none';
                uploadContainer.style.display = 'block';
                uploadStatus2.innerHTML = 'Video upload in progress...';

                const formData = new FormData();
                formData.append('face_video', videoBlob, `face_${Date.now()}.webm`);

                const xhr = new XMLHttpRequest();

                // Event listener for upload progress
                progressBar.style.width = '0%';
                progressBar.textContent = '0%';
                xhr.upload.addEventListener('progress', function (event) {
                    if (event.lengthComputable) {
                        const percentComplete = (event.loaded / event.total) * 100;
                        progressBar.style.width = percentComplete.toFixed(2) + '%';
                        progressBar.textContent = percentComplete.toFixed(2) + '%';
                        uploadStatus.textContent = `Uploading: ${percentComplete.toFixed(2)}%`;
                    }
                }, false);

                // Event listener for upload complete (success or failure)
                xhr.addEventListener('load', function () {
                    if (xhr.status >= 200 && xhr.status < 300) {
                        let response = JSON.parse(xhr.responseText);
                        if (response.status) {
                            uploadStatus.textContent = 'Upload complete!';
                            progressBar.style.width = '100%';
                            progressBar.textContent = '100%';
                            progressBar.style.backgroundColor = '#4CAF50'; // Green on success
                        } else {
                            uploadStatus.textContent = 'Upload failed!'
                            progressBar.style.backgroundColor = '#f44336';
                        }
                        uploadStatus2.innerHTML = '';
                    } else {
                        uploadStatus.textContent = 'Upload failed!';
                        uploadStatus2.innerHTML = 'Status: ' + xhr.status + ' ' + xhr.statusText;
                        progressBar.style.backgroundColor = '#f44336'; // Red on error
                        progressBar.textContent = 'ERROR';
                    }
                }, false);

                // Event listener for network errors
                xhr.addEventListener('error', function () {
                    uploadStatus2.textContent = 'Network error during upload.';
                    uploadStatus.textContent = 'Upload failed!';
                    progressBar.style.backgroundColor = '#f44336'; // Red on error
                    progressBar.textContent = 'ERROR';
                    console.error('XHR Upload Error');
                }, false);

                // Open and send the request
                xhr.open('POST', '{{route('user.kyc.upload-face')}}'); // Your server endpoint
                xhr.setRequestHeader('X-CSRF-TOKEN', '{{ csrf_token() }}');
                xhr.setRequestHeader('Accept', 'application/json');
                xhr.send(formData);
            })

            // Countdown before recording starts
            function startCountdown() {
                uploadBtn.style.display = 'none';

                let count = 3;
                countdownTimerEl.style.display = 'block';
                countdownTimerEl.textContent = `{{__('Recording will start in')}} ${count} {{__('seconds')}}`;
                recordingStatus.style.display = 'block';
                recordingStatus.textContent = `{{__('Please look directly at the camera and read above message.')}}`;

                startBtn.disabled = true;

                countdown = setInterval(() => {
                    count--;
                    if (count > 0) {
                        countdownTimerEl.textContent = `{{__('Recording will start in')}} ${count} {{__('seconds')}}`;
                    } else {
                        clearInterval(countdown);
                        countdownTimerEl.style.display = 'none';
                        startRecording();
                    }
                }, 1000);
            }

            // Start the actual recording
            function startRecording() {
                recordedChunks = [];
                mediaRecorder.start(100); // Collect 100ms chunks
                isRecording = true;

                // Update UI
                stopBtn.disabled = false;
                startBtn.style.display = 'none';
                stopBtn.style.display = 'inline-block';
                uploadBtn.style.display = 'none';


                recordingStatus.style.display = 'block';
                recordingIndicator.style.display = 'block';

                // Set recording timer
                let secondsLeft = MAX_RECORDING_TIME;
                recordingStatus.textContent = `{{__('Recording in progress:')}} ${secondsLeft} {{__('seconds remaining')}}`;

                recordingTimer = setInterval(() => {
                    secondsLeft--;
                    recordingStatus.textContent = `{{__('Recording in progress:')}} ${secondsLeft} {{__('seconds remaining')}}`;

                    if (secondsLeft <= 0) {
                        clearInterval(recordingTimer);
                        stopBtn.click(); // Auto stop recording
                        stopBtn.style.display = 'none';
                        startBtn.style.display = 'inline-block';
                    }
                }, 1000);
            }
        });
    </script>
@endpush

@push('css')
    <style>
        .face-verification-container {
            border: 1px solid #e0e0e0;
            padding: 20px;
            border-radius: 8px;
            background-color: #f9f9f9;
        }

        #video-preview {
            background-color: #000;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        #recording-status {
            font-weight: 500;
        }

        #countdown-timer {
            font-size: 1.2rem;
            text-align: center;
            font-weight: bold;
        }

        #recording-indicator {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0.85rem;
        }

        .text-recording {
            color: #fff;
            display: inline-flex;
            align-items: center;
            gap: 0.25rem;
            animation: blink_indicator 1000ms infinite;
            transition: opacity 300ms ease-in-out;
        }

        .text-recording svg {
            color: #ff0000;
        }

        @keyframes blink_indicator {
            0% {
                opacity: 0;
            }
            50% {
                opacity: 1;
            }
            100% {
                opacity: 0;
            }
        }
    </style>
@endpush
