@fragment('verify-form')
    <div
        class="form-group"
        id="phone_number_container"
        x-data="{
            waiting: false,
            waiting_time: 0,
            intervalId: null,
            sending: false,
            waitingTimer () {
                this.waiting = true;
                this.waiting_time = 120;
                this.intervalId = setInterval(() => {
                    this.waiting_time--;
                    if (this.waiting_time <= 0) {
                        this.waiting = false;
                        clearInterval(this.intervalId);
                    }
                }, 1000);
            }
        }"
        hx-target="this"
        hx-ext="alpine-morph" hx-swap="morph"
        x-init="waitingTimer()"
        @htmx:after-swap="waitingTimer()"
    >
        <label class="form-label required">{{__('Phone Number')}}</label>
        <div class="input-group">
            <input name="phone" class="form-control form--control" autocomplete="off"
                   placeholder="{{__('Phone Number')}}" type="tel"
                   value="{{ auth()->user()->phone }}" required
                   id="phone_number"
            >
        </div>
        <div class="my-1">
            <a
                href="javascript:void(0)"
                hx-post="{{ route('user.profile.send-phone-otp') }}"
                hx-include="#phone_number"
                x-show="!waiting"
                x-cloak
                @htmx:before-send="$el.setAttribute('disabled', true)"
                class="text-decoration-none"
            >
                <span class="htmx-hide">Resend OTP</span>
                <span class="htmx-indicator">
                    <span class="spinner-border spinner-border-sm"></span>
                    Resending OTP...
                </span>
            </a>
            <span x-show="waiting" x-cloak
                  x-text="`You can resend after ${waiting_time} seconds`">
                You can resend after 60 seconds
            </span>
        </div>
        <div id="otp_verify" class="mt-2">
            <form hx-post="{{ route('user.profile.verify-phone-otp', absolute: false) }}"
                  hx-target="#phone_number_container">
                @csrf
                <div class="input-group">
                    <input type="text"
                           class="form-control form--control {{ isset($verified) && !$verified ? "border-danger" : "" }}"
                           name="otp" placeholder="OTP"/>
                    <button class="btn">
                        <span class="htmx-hide">Verify OTP</span>
                        <span class="htmx-indicator">
                            <span class="spinner-border spinner-border-sm"></span>
                            Verifying...
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>
@endfragment
@fragment('verify-response')
    <div class="form-group" hx-target="this">
        <label class="form-label required">{{__('Phone Number')}}</label>
        <div class="input-group">
            <input name="phone" class="form-control form--control" autocomplete="off"
                   placeholder="{{__('Phone Number')}}" type="tel"
                   value="{{ auth()->user()->phone }}" required
                   id="phone_number"
            >
            <div class="input-group-text text-success fw-bold"> Verified</div>
        </div>
    </div>
@endfragment
