<form
    action="{{ route('payment.login', [$paymentRequest->id], false) }}"
    method="POST"
    hx-post="{{ route('payment.login', [$paymentRequest->id], false) }}"
    hx-trigger="submit"
>
    @csrf
    <div class="text-center mb-3">
        <img src="{{asset('assets/images/'.$gs->logo)}}" width="110" height="32" alt="Logo"
             class="payment-logo"/>
    </div>
    <div class="text-center mb-3">
        <h3>Sign in to pay</h3>
    </div>
    <div class="from-group mb-3">
        <input type="email" name="email"
               class="form-control form--control {{ $errors->has('email') ? 'is-invalid' : '' }}"
               placeholder="Email"/>
        @error('email')
        <div class="invalid-feedback">
            {{ $message }}
        </div>
        @enderror
    </div>
    <div class="from-group mb-3">
        <input type="password" name="password" class="form-control form--control" placeholder="Password"/>
    </div>
    <button class="btn btn-primary w-100">
        <span class="htmx-hide">Sign in</span>
        <span class="htmx-indicator">
            <span class="d-inline-flex align-items-center">
                <span class="spinner-border spinner-border-sm"></span>
                <span>Signing in...</span>
            </span>
        </span>
    </button>
</form>
