@extends('layouts.user')

@push('css')

@endpush

@section('contents')

    <div class="page-body">
        <div class="container-xl">
            <div class="row justify-content-center">
                <div class="col-sm-8 col-md-6">
                    <div class="card border-0 shadow-sm">
                        <div class="card-header">
                            <h5 class="card-title text-dark text-center">@lang('Verify 2FA OTP')</h5>
                        </div>
                        <div class="card-body py-5">
                            @if(session('success'))
                                <div class="alert alert-success bg-success-lt mx-4 mx-md-5">{{session('success')}}</div>
                            @endif
                            <p class="text-center">@lang('An email with OTP sent to your email address for the verification')</p>
                            <form action="{{ route('user.2fa.verify.email') }}" method="POST" class="mt-3">
                                @csrf
                                <div class="form-group mx-auto text-center" style="max-width: 220px">
                                    <input type="number" class="form-control form--control" placeholder="Enter OTP"
                                           name="otp">
                                    @error('otp') <small class="text-danger">{{$message}}</small> @enderror
                                </div>
                                <div class="text-center mt-3">
                                    <button class="btn btn-primary" type="submit">Continue</button>
                                </div>
                            </form>
                            <form action="{{ route('user.2fa.verify.resend-email') }}" method="post"
                                  class="text-center mt-3">
                                @csrf
                                <button class="btn btn-link text-decoration-none text-dark" type="submit">
                                    Resend 2FA OTP email
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

<x-htmx-alpine/>

