@extends('layouts.user')

@section('styles')

@endsection

@section('contents')
    <div class="container-xl">
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <h2 class="page-title">
                        {{__('KYC Form')}}
                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-12">
                    <div class="card p-5">
                        <div class="gocover"
                             style="background: url({{ asset('assets/images/'.$gs->loader) }}) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div>
                        @includeIf('includes.flash')
                        <div class="text-center text-danger">
                            <h5> Please Fill-up this form vary carefully. Because brfore you rejected</h5>
                        </div>
                        <form action="{{route('user.kyc.submit.again')}}" method="POST" enctype="multipart/form-data">
                            @csrf

                            <div class="mb-4">
                                <h4>Approved Information</h4>
                                <table class="table border-top">
                                    @if(!in_array('kyc_face', $kycReject['rejected']??[]))
                                        <tr>
                                            <th>KYC Face Video</th>
                                            <td width="5%">:</td>
                                            <td>
                                                <strong>Verified</strong>
                                            </td>
                                        </tr>
                                    @endif
                                    @foreach ($userForms as $field)
                                        @php
                                            $fieldName = strtolower(str_replace(' ', '_', $field->label));
                                        @endphp
                                        @if(in_array($fieldName, $kycReject['rejected']??[]))
                                            @continue
                                        @endif
                                        <tr>
                                            <th>{{$field->label}}</th>
                                            <td width="5%">:</td>
                                            <td>
                                                @if($field->type == 2)
                                                    <a href="{{asset('assets/images/'.($kycInfo[$fieldName][0] ?? ''))}}"
                                                       target="_blank">
                                                        <img
                                                            src="{{asset('assets/images/'.($kycInfo[$fieldName][0] ?? ''))}}"
                                                            class="img-thumbnail" width="200">
                                                    </a><br>
                                                    <a href="{{asset('assets/images/'.($kycInfo[$fieldName][0] ?? ''))}}"
                                                       download>Download</a>
                                                @else
                                                    {{$kycInfo[$fieldName][0] ?? ''}}
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </table>
                            </div>

                            @if(!empty($kycReject['reject_reason']))
                                <div class="mb-4">
                                    <h4>Rejection Reason</h4>
                                    {{ $kycReject['reject_reason']??'' }}
                                </div>
                            @endif

                            <h4>Rejected Information</h4>

                            @if(in_array('kyc_face', $kycReject['rejected']??[]))
                                <x-face-verification-video/>
                            @endif

                            @foreach ($userForms as $field)
                                @php
                                    $fieldName = strtolower(str_replace(' ', '_', $field->label));
                                @endphp
                                @if(!in_array($fieldName, $kycReject['rejected']??[]))
                                    @continue
                                @endif
                                @if ($field->type == 1 || $field->type == 3 )
                                    <div class="form-group mb-3 mt-3">
                                        <label
                                            class="form-label {{$field->required == 1 ? 'required':'Optional'}}">@lang($field->label)</label>
                                        @if ($field->type == 1)
                                            <input
                                                type="text"
                                                name="{{$fieldName}}"
                                                class="form-control" autocomplete="off"
                                                placeholder="@lang($field->label)"
                                                min="1"
                                                value="{{in_array($fieldName, $kycReject['rejected']??[])?'':$kycInfo[$fieldName][0]}}"
                                                {{$field->required == 1 ? 'required':'Optional'}}
                                            >
                                        @else
                                            <textarea class="form-control"
                                                      name="{{$fieldName}}"
                                                      placeholder="@lang($field->label)">{{in_array($fieldName, $kycReject['rejected']??[])?'':$kycInfo[$fieldName][0]}}</textarea>
                                        @endif
                                    </div>
                                @elseif($field->type == 2)
                                    <div class="form-group mb-3 mt-3">
                                        <label
                                            class="form-label {{$field->required == 1 ? 'required':'Optional'}}">@lang($field->label)</label>
                                        <input type="file" name="{{$fieldName}}"
                                               class="form-control"
                                               autocomplete="off" {{$field->required == 1 ? 'required':'Optional'}}>
                                    </div>
                                @endif
                            @endforeach

                            <div class="form-footer">
                                <button type="submit" class="btn btn-primary w-100">{{__('Submit')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('js')

@endpush
