@extends('layouts.user')

@section('contents')
    <div class="container-xl">
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <h2 class="page-title">
                        {{ __('Agent  User') }}
                    </h2>
                </div>

            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            <!-- Row -->
            <div class="row mt-3">
                <!-- Datatables -->
                <div class="col-lg-12">

                    @include('includes.admin.form-success')

                    <div class="card mb-4">
                        <div class="table-responsive p-3">
                            <table id="geniustable" class="table table-hover" cellspacing="0" width="100%">
                                <thead class="thead-light">
                                    <tr class="dt-column-filter">
                                        <th class="px-2 py-1">

                                        </th>
                                        <th class="px-2 py-1">
                                            <input type="text" class="form-control  mb-0"
                                                placeholder="{{ __('Search Name') }}" />
                                        </th>
                                        <th class="px-2 py-1">
                                            <input type="text" class="form-control  mb-0"
                                                placeholder="{{ __('Search Email') }}">
                                        </th>
                                        <th class="px-2 py-1">
                                            <input type="text" class="form-control  mb-0"
                                                placeholder="{{ __('Search Country') }}">
                                        </th>
                                        <th class="px-2 py-1">
                                            <input type="text" class="form-control  mb-0"
                                                placeholder="{{ __('Search Address') }}">
                                        </th>
                                        <th class="px-2 py-1">
                                            <input type="text" class="form-control  mb-0"
                                                placeholder="{{ __('Search Acount') }}">
                                        </th>

                                        <th class="px-2 py-1">
                                            <input type="text" class="form-control  mb-0"
                                                placeholder="{{ __('Search Telegram') }}">
                                        </th>


                                        <th class="px-2 py-1">
                                            <select type="text" class="form-control  mb-0">
                                                <option value="">All</option>
                                                <option value="agent">Agent</option>
                                                <option value="merchant">Merchant</option>
                                            </select>
                                        </th>

                                    </tr>
                                    <tr>
                                        <th>{{ __('ID#') }}</th>
                                        <th nowrap>{{ __('Name') }}</th>
                                        <th nowrap>{{ __('Email') }}</th>
                                        <th nowrap>{{ __('Country') }}</th>
                                        <th nowrap>{{ __('Address') }}</th>
                                        <th nowrap>{{ __('Account') }}</th>
                                        <th nowrap>{{ __('Telegram') }}</th>
                                        <th nowrap>{{ __('Account Type') }}</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- DataTable with Hover -->

            </div>
            <!--Row-->
        </div>
    </div>
@endsection


@push('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/2.3.2/css/dataTables.bootstrap5.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

    <style>
        #dt-search-0.form-control-sm,
        .dt-length #dt-length-0.form-select-sm {
            height: auto;
            padding: .28rem .75rem;
            font-size: 1rem;
        }

        table.dataTable th.dt-type-numeric,
        table.dataTable th.dt-type-date,
        table.dataTable td.dt-type-numeric,
        table.dataTable td.dt-type-date {
            text-align: left;
        }
    </style>
@endpush


@push('js')
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.datatables.net/2.3.2/js/dataTables.js"></script>
    <script src="https://cdn.datatables.net/2.3.2/js/dataTables.bootstrap5.js"></script>
    <script>
        $(function() {
            var table = $('#geniustable').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('user.otheruser.datatable') }}',
                columns: [{
                        data: 'id',
                        name: 'id',
                        className: 'text-left'
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'email',
                        name: 'email'
                    },
                    {
                        data: 'country',
                        name: 'country'
                    },
                    {
                        data: 'city',
                        name: 'city'
                    },

                    {
                        data: 'account_number',
                        name: 'account_number'
                    },
                    {
                        data: 'telegram',
                        name: 'telegram'
                    },
                    {
                        data: 'account_type',
                        name: 'account_type'
                    },
                ],
                order: [
                    [0, 'desc']
                ],
            });

            // Apply column filters
            $('#geniustable .dt-column-filter th').each(function(i) {
                $('input, select', this).on('keyup change', function() {
                    if (table.column(i).search() !== this.value) {
                        table.column(i).search(this.value).draw();
                    }
                });
            });
        });
    </script>
@endpush
