@extends('layouts.user')

@push('css')

@endpush

@section('contents')
    <div class="container-xl">
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <h2 class="page-title">
                        {{__('Withdraw Now')}}
                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-12">
                    <div class="card p-5">
                        <div class="gocover"
                             style="background: url({{ asset('assets/images/'.$gs->loader) }}) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div>

                        @if ($gs->withdraw_status == 0)
                            <p class="text-center text-danger">{{__('WithDraw is temporary Off')}}</p>
                        @else
                            @includeIf('includes.flash')
                            <form action="{{route('user.withdraw.store')}}" method="POST" enctype="multipart/form-data">
                                @csrf

                                <div class="form-group">
                                    <label class="form-label required">{{__('Withdraw Method')}}</label>
                                    <select name="methods" id="withmethod" class="form-select" required>
                                        <option value="">{{ __('Select Withdraw Method') }}</option>
                                        @foreach ($methods as $data)
                                            <option value="{{$data->id}}" data-id="{{$data->id}}">
                                                {{$data->name ?? $data->title}}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div id="withdraw_note" class="d-none">
                                    <div class="card shadow-sm mt-3">
                                        <div class="card-body"></div>
                                    </div>
                                </div>

                                <input type="hidden" name="gateway_id" id="gateway_id"/>
                                <input type="hidden" name="currency_sign" value="{{ $currency->sign }}">
                                <input type="hidden" id="currencyCode" name="currency_code"
                                       value="{{ $currency->name }}">
                                <input type="hidden" name="currency_id" value="{{ $currency->id }}">

                                <div class="form-group mb-3 mt-3">
                                    <label class="form-label required">{{__('Withdraw Amount')}} in ({{globalCurrency()->name}})</label>
                                    <div class="input-group">
                                                <div id="charge_display" class="input-group-text bg-danger text-white fw-bold">
                                                    Charge: {{globalCurrency()->sign}} 0.00
                                                </div>
                                        <input name="amount" id="amount" class="form-control" autocomplete="off"
                                            placeholder="{{__('0.0')}}" type="number" value="{{ old('amount') }}" min="1"
                                            required>
                                    </div>
                                </div>

                                <div class="form-group mb-3 ">
                                    <label class="form-label required">{{__('Description')}}</label>
                                    <textarea name="details" class="form-control nic-edit" cols="30" rows="5"
                                              placeholder="{{__('Receive account details')}}" required></textarea>
                                </div>

                                <div class="form-footer">
                                    <button type="submit" class="btn btn-primary w-100">{{__('Submit')}}</button>
                                </div>


                            </form>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('js')
    <script>
        $(function () {
            const methods = {!! json_encode($methods->mapWithKeys(fn($item) => [$item->id => $item->only(['withdraw_note'])])) !!};
            $(document).on('change', '#withmethod', function () {
                const option = $(this).find('option:selected');
                const method = methods[option.data('id')];
                const withdrawNote = $('#withdraw_note').get(0);
                $('#gateway_id').val(option.data('id'));
                $(withdrawNote).addClass('d-none');
                if (method?.withdraw_note) {
                    $(withdrawNote).find('.card-body').html(method.withdraw_note ?? '');
                    $(withdrawNote).removeClass('d-none');
                }
            });

            let fixed = parseFloat(@json($fixed));
            let percent = parseFloat(@json($percent));

                $("#withmethod").on('change', function () {
                    let selectedMethod = $(this).val();
                    let url = `${mainurl}/user/get/withdraw/fee/${selectedMethod}`;

                    $.get(url, function (data) {
                        fixed = parseFloat(data.fixed);
                        percent = parseFloat(data.percent);
                        updateCharge();
                    });
                });

                function updateCharge() {
                    let amount = parseFloat($("#amount").val()) || 0;
                    let totalCharge = fixed + (amount * (percent / 100));
                    let currency = @json(globalCurrency()->sign);
                    $("#charge_display").text(`Charge: ${currency} ${totalCharge.toFixed(2)}`);
                }

                $("#amount").on('input', function () {
                    updateCharge();
                });
        })
    </script>
@endpush
