<?php

use App\Http\Controllers\PaymentController;

Route::group(['prefix' => 'payment'], function () {
    Route::post('request', [PaymentController::class, 'paymentRequest'])->name('payment.request');
    Route::post('login/{requestId}', [PaymentController::class, 'login'])->name('payment.login');
    Route::post('process/{requestId}', [PaymentController::class, 'process'])->name('payment.process');
    Route::get('cancel/{requestId}', [PaymentController::class, 'cancel'])->name('payment.cancel');
    Route::get('{merchantId}/{requestId}', [PaymentController::class, 'index'])->name('payment.payment');
});
Route::group(['prefix' => 'api/payment'], function () {
    Route::post('request', [PaymentController::class, 'paymentRequest'])->name('payment.request.api');
});
