<?php
    use App\Models\UserDps;
    use App\Models\UserFdr;
    use App\Models\UserLoan;
?>


<?php $__env->startSection('content'); ?>

    <div class="d-sm-flex align-items-center justify-content-between mb-4 py-3">
        <h1 class="h3 mb-0 text-gray-800"><?php echo e(__('Dashboard')); ?></h1>
        <ol class="breadcrumb m-0 py-0">
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
        </ol>
    </div>
    <?php if(Session::has('cache')): ?>
        <div class="alert alert-success validation">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span
                    aria-hidden="true">×</span></button>
            <h3 class="text-center"><?php echo e(Session::get('cache')); ?></h3>
        </div>
    <?php endif; ?>

    <div class="row mb-3">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Active Customers')); ?></div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(count($acustomers)); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Blocked Customers')); ?></div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(count($bcustomers)); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user fa-2x text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Blogs')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800"><?php echo e(count($blogs)); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-fw fa-newspaper fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Deposits')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800"><?php echo e(count($deposits)); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Loan')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800"><?php echo e(count(UserLoan::get())); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-cash-register fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Pending Loan')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                <?php echo e(count(UserLoan::whereStatus(0)->get())); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-cash-register fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Running Loan')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                <?php echo e(count(UserLoan::whereStatus(1)->get())); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-cash-register fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Paid Loan')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                <?php echo e(count(UserLoan::whereStatus(3)->get())); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-cash-register fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Rejected Loan')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                <?php echo e(count(UserLoan::whereStatus(2)->get())); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-cash-register fa-2x text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total DPS')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800"><?php echo e(count(UserDps::get())); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-warehouse fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Running DPS')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                <?php echo e(count(UserDps::whereStatus(1)->get())); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-warehouse fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Matured DPS')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                <?php echo e(count(UserDps::whereStatus(2)->get())); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-warehouse fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total FDR')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800"><?php echo e(count(UserFdr::get())); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-shield fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Running FDR')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                <?php echo e(count(UserFdr::whereStatus(1)->get())); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-shield fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Closed FDR')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                <?php echo e(count(UserFdr::whereStatus(2)->get())); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-shield fa-2x text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Bonus Point')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                <?php echo e($totalBonusPoint); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-coins fa-2x text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Transactions')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800"><?php echo e(count($transactions)); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <div class="row mb-3">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Customer Balance')); ?>

                            </div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                <?php echo e(amount_format($usersTotalBalance)); ?> <?php echo e($currency->name); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Customer Loan')); ?>

                            </div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                <?php echo e(amount_format($loanamount)); ?> <?php echo e($currency->name); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Customer Dps')); ?>

                            </div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                <?php echo e(amount_format($dpsamount)); ?> <?php echo e($currency->name); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Customer Fdr')); ?>

                            </div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                <?php echo e(amount_format($fdramount)); ?> <?php echo e($currency->name); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Deposit Amount')); ?>

                            </div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800"><?php echo e(amount_format($depositAmount)); ?>

                                <?php echo e($currency->name); ?> </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Withdraw Amount')); ?>

                            </div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800"><?php echo e(amount_format($withdrawAmount)); ?>

                                <?php echo e($currency->name); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

            <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1"><?php echo e(__('Total Withdraw Pending Amount')); ?>

                            </div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800"><?php echo e(amount_format($withdrawPendingAmount)); ?>

                                <?php echo e($currency->name); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-uppercase mb-1">
                                <?php echo e(__('Total Withdraw Charge Amount')); ?></div>
                            <div class="h6 mb-0 mt-2 font-weight-bold text-gray-800">
                                <?php echo e(amount_format($withdrawChargeAmount)); ?> <?php echo e($currency->name); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-xl-12 col-lg-12 mb-4">
            <div class="card">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Profit & Loss'); ?></h6>
                </div>
                <canvas id="profitLossChart" style="min-height: 350px; height: 350px;"></canvas>
            </div>
        </div>
    </div>


    <div class="row mb-3">
        <div class="col-xl-12 col-lg-12 mb-4">
            <div class="card">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Recent Joined Users'); ?></h6>
                </div>
                <?php if(count($users) > 0): ?>
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                                <tr>
                                    <th><?php echo app('translator')->get('Serial No'); ?></th>
                                    <th><?php echo app('translator')->get('Name'); ?></th>
                                    <th><?php echo app('translator')->get('Email'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td data-label="<?php echo app('translator')->get('Serial No'); ?>"><?php echo e($loop->iteration); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Name'); ?>"><?php echo e($data->name); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Email'); ?>"><?php echo e($data->email); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Status'); ?>"><span
                                                class="badge badge-<?php echo e($data->is_banned == 0 ? 'success' : 'danger'); ?>"><?php echo e($data->is_banned == 0 ? 'activated' : 'deactivated'); ?></span>
                                        </td>
                                        <td data-label="<?php echo app('translator')->get('Action'); ?>"><a
                                                href="<?php echo e(route('admin-user-show', $data->id)); ?>"
                                                class="btn btn-sm btn-primary"><?php echo app('translator')->get('Detail'); ?></a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="card-footer"></div>
                <?php else: ?>
                    <p class="text-center"><?php echo app('translator')->get('NO USER FOUND'); ?></p>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const rawData = <?php echo json_encode($monthlyProfitLoss ?? [], 15, 512) ?>;

        if (!Array.isArray(rawData)) {
            console.error("Profit/loss data is not an array:", rawData);
            return;
        }

        const labels = rawData.map(item => item.month);
        const netValues = rawData.map(item => item.net);

        const ctx = document.getElementById('profitLossChart').getContext('2d');
        const currencySign = <?php echo json_encode(globalCurrency()->sign, 15, 512) ?>;

        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: labels,
                datasets: [{
                    label: 'Profit / Loss',
                    data: netValues,
                    backgroundColor: netValues.map(v => v >= 0 ? 'rgba(40, 167, 69, 0.8)' : 'rgba(220, 53, 69, 0.8)'),
                    borderColor: netValues.map(v => v >= 0 ? 'rgba(40, 167, 69, 1)' : 'rgba(220, 53, 69, 1)'),
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    title: {
                        display: true,
                        text: 'Monthly Profit / Loss (Last 12 Months)'
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const val = context.raw;
                                const type = val >= 0 ? 'Profit' : 'Loss';
                                return `${type}: ${currencySign}${Math.abs(val)}`;
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return currencySign + value;
                            }
                        }
                    }
                }
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/amitsaha/Public/Project/personal/bank/core/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>